/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.varselector.ratioselector.ratios;

import choco.cp.solver.search.integer.varselector.ratioselector.ratios.IntRatio;

public abstract class AbstractRatio
implements IntRatio {
    private int dividend;
    private int divisor;

    @Override
    public final int initailizeDividend() {
        return this.dividend;
    }

    public final void setDividend(int dividend) {
        assert (dividend >= 0);
        this.dividend = dividend;
    }

    @Override
    public final int getDivisor() {
        return this.divisor;
    }

    public final void setDivisor(int divisor) {
        assert (divisor >= 0);
        this.divisor = divisor;
    }

    protected abstract int initializeDividend();

    protected abstract int initializeDivisor();

    @Override
    public boolean isActive() {
        if (this.getIntVar().isInstantiated()) {
            return false;
        }
        this.dividend = this.initializeDividend();
        this.divisor = this.initializeDivisor();
        return true;
    }

    public final void setMaxRatioValue() {
        this.dividend = 1;
        this.divisor = 0;
    }

    public final void setZeroRatioValue() {
        this.dividend = 0;
        this.divisor = 1;
    }

    public final void setRatio(IntRatio ratio) {
        this.setDividend(ratio.initailizeDividend());
        this.setDivisor(ratio.getDivisor());
    }

    public String toString() {
        return (this.getIntVar() == null ? "" : this.getIntVar().toString() + "->") + this.initailizeDividend() + "/" + this.getDivisor();
    }

    @Override
    public final int compareTo(IntRatio o) {
        long b;
        long a = this.getLeftMember(o);
        if (a > (b = this.getRightMember(o))) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public final long getLeftMember(IntRatio ratio) {
        return (long)this.initailizeDividend() * (long)ratio.getDivisor();
    }

    public final long getRightMember(IntRatio ratio) {
        return (long)ratio.initailizeDividend() * (long)this.getDivisor();
    }
}

