/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver;

import choco.kernel.common.util.tools.PropertyUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Properties;

public class Configuration
extends Properties {
    private static final long serialVersionUID = 683407604054548550L;
    protected static final String VALUE_TRUE = "true";
    protected static final String VALUE_FALSE = "false";
    protected static final String VALUE_OFF = "OFF";
    @Default(value="true")
    public static final String STOP_AT_FIRST_SOLUTION = "cp.resolution.stop_at_first_solution";
    @Default(value="SATISFACTION")
    public static final String RESOLUTION_POLICY = "cp.resolution.policy";
    @Default(value="false")
    public static final String RESTART_AFTER_SOLUTION = "cp.restart.after_solution";
    @Default(value="false")
    public static final String RESTART_LUBY = "cp.restart.luby";
    @Default(value="false")
    public static final String RESTART_GEOMETRICAL = "cp.restart.geometrical";
    @Default(value="512")
    public static final String RESTART_BASE = "cp.restart.base";
    @Default(value="2")
    public static final String RESTART_LUBY_GROW = "cp.restart.luby.grow";
    @Default(value="1.2")
    public static final String RESTART_GEOM_GROW = "cp.restart.geometrical.grow";
    @Default(value="BACKTRACK")
    public static final String RESTART_POLICY_LIMIT = "cp.restart.policy.limit.type";
    @Default(value="false")
    public static final String NOGOOD_RECORDING_FROM_RESTART = "cp.restart.nogood_recording";
    @Default(value="1")
    public static final String RECOMPUTATION_GAP = "cp.recomputation.gap";
    @Default(value="true")
    public static final String CARD_REASONNING = "cp.propagation.cardinality_reasonning";
    @Default(value="0")
    public static final String RANDOM_SEED = "cp.random.seed";
    @Default(value="UNDEF")
    public static final String SEARCH_LIMIT = "cp.search.limit.type";
    @Default(value="2147483647")
    public static final String SEARCH_LIMIT_BOUND = "cp.search.limit.value";
    @Default(value="UNDEF")
    public static final String RESTART_LIMIT = "cp.restart.limit.type";
    @Default(value="2147483647")
    public static final String RESTART_LIMIT_BOUND = "cp.restart.limit.value";
    @Default(value="false")
    public static final String INIT_SHAVING = "cp.init.propagation.shaving";
    @Default(value="false")
    public static final String INIT_DESTRUCTIVE_LOWER_BOUND = "cp.init.propagation.dLB";
    @Default(value="false")
    public static final String INIT_DLB_SHAVING = "cp.init.propagation.shaving.dLB";
    @Default(value="true")
    public static final String INIT_SHAVE_ONLY_DECISIONS = "cp.init.propagation.shaving.only_decision_vars";
    @Default(value="false")
    public static final String BOTTOM_UP = "cp.search.bottom_up";
    @Default(value="21474836")
    public static final String HORIZON_UPPER_BOUND = "cp.scheduling.horizon";
    @Default(value="1")
    public static final String SOLUTION_POOL_CAPACITY = "cp.solution.pool_capacity";
    @Default(value="true")
    public static final String RESTORE_BEST_SOLUTION = "cp.solution.restore";
    @Default(value="1.0e-6")
    public static final String REAL_PRECISION = "cp.real.precision";
    @Default(value="0.99")
    public static final String REAL_REDUCTION = "cp.real.reduction";
    @Default(value="0.7f")
    public static final String RATION_HOLE = "cp.domain.rationHole";
    @Default(value="1234567")
    public static final String VEQ_ORDER = "cp.propagation.variables.order";
    @Default(value="1234567")
    public static final String CEQ_ORDER = "cp.propagation.constraints.order";

    public Configuration() {
        super(new Properties());
        this.load(this.defaults);
    }

    public Configuration(Properties defaults) {
        super(defaults);
    }

    public void setDefault() {
        this.clear();
        this.load(this);
    }

    private void load(Properties properties) {
        Field[] fields;
        for (Field f : fields = this.getClass().getFields()) {
            Default annotation = f.getAnnotation(Default.class);
            try {
                properties.put(f.get(this), annotation.value());
            }
            catch (IllegalAccessException e) {
                PropertyUtils.logOnFailure(f.getName());
            }
        }
        PropertyUtils.logOnSuccess("default");
    }

    public String loadDefault(String key) {
        Field[] fields;
        for (Field f : fields = Configuration.class.getFields()) {
            try {
                if (!f.get(this).equals(key)) continue;
                Default ann = f.getAnnotation(Default.class);
                return ann.value();
            }
            catch (IllegalAccessException e) {
                PropertyUtils.logOnFailure(key);
            }
        }
        throw new NullPointerException("cant find ");
    }

    public boolean readBoolean(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            value = this.loadDefault(key);
        }
        return Boolean.valueOf(value);
    }

    public boolean readBoolean(String key, boolean defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Boolean.parseBoolean(b);
    }

    public int readInt(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return Integer.valueOf(value);
    }

    public int readInt(String key, int defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Integer.parseInt(b);
    }

    public File readFile(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return new File(value);
    }

    public File readFile(String key, File defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return new File(b);
    }

    public long readLong(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return Long.parseLong(value);
    }

    public long readLong(String key, long defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Long.parseLong(b);
    }

    public double readDouble(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return Double.valueOf(value);
    }

    public double readDouble(String key, double defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return Double.parseDouble(b);
    }

    public String readString(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return value;
    }

    public String readString(String key, String defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return b;
    }

    public <T extends Enum<T>> T readEnum(String key, Class clazz) {
        String value = this.getProperty(key);
        if (value == null) {
            PropertyUtils.logOnAbsence(key);
            throw new NullPointerException("cant find ");
        }
        return Enum.valueOf(clazz, value);
    }

    public <T extends Enum<T>> T readEnum(String key, T defaultValue) {
        String b = this.getProperty(key);
        if (b == null) {
            PropertyUtils.logOnAbsence(key);
            return defaultValue;
        }
        return (T)Enum.valueOf(defaultValue.getClass(), b);
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putTrue(String key) {
        this.putBoolean(key, true);
    }

    public void putFalse(String key) {
        this.putBoolean(key, false);
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public void putEnum(String key, Enum value) {
        this.put(key, value.name());
    }

    public void putFile(String key, File value) {
        this.put(key, value.getAbsolutePath());
    }

    public void storeDefault(File file, String comments) throws IOException {
        if (this.defaults != null) {
            this.defaults.store(new FileWriter(file), comments);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Default {
        public String value();
    }
}

