/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class Element
extends AbstractBinIntSConstraint {
    int[] lval;
    int cste;

    public Element(IntDomainVar index, int[] values, IntDomainVar var, int offset) {
        super(index, var);
        this.lval = values;
        this.cste = offset;
    }

    public Element(IntDomainVar index, int[] values, IntDomainVar var) {
        this(index, values, var, 0);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return "Element";
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            return 12;
        }
        return 4;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.updateIndexFromValue();
        this.updateValueFromIndex();
    }

    @Override
    public String pretty() {
        return this.v1.pretty() + " = nth(" + this.v0.pretty() + ", " + StringUtils.pretty(this.lval) + ")";
    }

    protected void updateValueFromIndex() throws ContradictionException {
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        int index = this.v0.getInf();
        while (index <= this.v0.getSup()) {
            if (minVal > this.lval[index - this.cste]) {
                minVal = this.lval[index - this.cste];
            }
            if (maxVal < this.lval[index - this.cste]) {
                maxVal = this.lval[index - this.cste];
            }
            index = this.v0.getNextDomainValue(index);
        }
        this.v1.updateInf(minVal, this, false);
        this.v1.updateSup(maxVal, this, false);
    }

    protected void updateIndexFromValue() throws ContradictionException {
        boolean forceAwake;
        int maxFeasibleIndex;
        int minFeasibleIndex = Math.max(0 + this.cste, this.v0.getInf());
        if (minFeasibleIndex > (maxFeasibleIndex = Math.min(this.v0.getSup(), this.lval.length - 1 + this.cste))) {
            this.fail();
        }
        boolean bl = forceAwake = !this.v1.hasEnumeratedDomain();
        while (this.v0.canBeInstantiatedTo(minFeasibleIndex) && !this.v1.canBeInstantiatedTo(this.lval[minFeasibleIndex - this.cste])) {
            ++minFeasibleIndex;
        }
        this.v0.updateInf(minFeasibleIndex, this, forceAwake);
        while (this.v0.canBeInstantiatedTo(maxFeasibleIndex) && !this.v1.canBeInstantiatedTo(this.lval[maxFeasibleIndex - this.cste])) {
            --maxFeasibleIndex;
        }
        this.v0.updateSup(maxFeasibleIndex, this, forceAwake);
        if (this.v0.hasEnumeratedDomain()) {
            for (int i = minFeasibleIndex + 1; i <= maxFeasibleIndex - 1; ++i) {
                if (!this.v0.canBeInstantiatedTo(i) || this.v1.canBeInstantiatedTo(this.lval[i - this.cste])) continue;
                this.v0.removeVal(i, this, forceAwake);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.updateIndexFromValue();
        this.updateValueFromIndex();
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        if (i == 0) {
            this.v1.instantiate(this.lval[this.v0.getVal() - this.cste], this, false);
        }
    }

    @Override
    public void awakeOnRem(int i, int x) throws ContradictionException {
        if (i == 0) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v1.isInstantiated()) {
            boolean allVal = true;
            boolean oneVal = false;
            int val = this.v0.getInf();
            while (val <= this.v0.getSup()) {
                boolean b = val - this.cste >= 0 && val - this.cste < this.lval.length && this.lval[val - this.cste] == this.v1.getVal();
                allVal &= b;
                oneVal |= b;
                val = this.v0.getNextDomainValue(val);
            }
            if (allVal) {
                return Boolean.TRUE;
            }
            if (oneVal) {
                return null;
            }
        } else {
            boolean b = false;
            int val = this.v0.getInf();
            while (val <= this.v0.getSup() && !b) {
                if (val - this.cste >= 0 && val - this.cste < this.lval.length) {
                    b = this.v1.canBeInstantiatedTo(this.lval[val - this.cste]);
                }
                val = this.v0.getNextDomainValue(val);
            }
            if (b) {
                return null;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (tuple[0] - this.cste >= this.lval.length || tuple[0] - this.cste < 0) {
            return false;
        }
        return this.lval[tuple[0] - this.cste] == tuple[1];
    }
}

