/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.kernel.solver.Configuration;
import choco.kernel.solver.Solver;

public class PreProcessConfiguration
extends Configuration {
    private static final long serialVersionUID = 683407604054648550L;
    @Configuration.Default(value="false")
    public static final String RESTART_MODE = "ppcp.restartMode";
    @Configuration.Default(value="true")
    public static final String INT_EQUALITY_DETECTION = "ppcp.detection.intEq";
    @Configuration.Default(value="true")
    public static final String TASK_EQUALITY_DETECTION = "ppcp.detection.taskEq";
    @Configuration.Default(value="true")
    public static final String DISJUNCTIVE_DETECTION = "ppcp.detection.disjunctive";
    @Configuration.Default(value="true")
    public static final String EXPRESSION_DETECTION = "ppcp.detection.expression";
    @Configuration.Default(value="true")
    public static final String CLIQUES_DETECTION = "ppcp.detection.cliques";
    @Configuration.Default(value="true")
    public static final String SYMETRIE_BREAKING_DETECTION = "ppcp.detection.cliques.symetrieBreaking";
    @Configuration.Default(value="true")
    public static final String DISJUNCTIVE_MODEL_DETECTION = "ppcp.detection.scheduling.disjMod";
    @Configuration.Default(value="true")
    public static final String DMD_USE_TIME_WINDOWS = "ppcp.detection.scheduling.disjMod.timeWindows";
    @Configuration.Default(value="true")
    public static final String DMD_GENERATE_CLAUSES = "ppcp.detection.scheduling.disjMod.clauses";
    @Configuration.Default(value="false")
    public static final String DMD_REMOVE_DISJUNCTIVE = "ppcp.detection.scheduling.disjMod.removeDisjunctive";
    @Configuration.Default(value="false")
    public static final String DISJUNCTIVE_FROM_CUMULATIVE_DETECTION = "ppcp.detection.scheduling.cumulative.disjunctive";

    public static final String getPreProcessMsg(Configuration conf) {
        StringBuilder b = new StringBuilder(18);
        if (conf.readBoolean(RESTART_MODE)) {
            b.append(" RESTART    ");
        }
        return new String(b);
    }

    public static final void cancelSchedulingPreProcess(Configuration conf) {
        conf.putFalse(DISJUNCTIVE_MODEL_DETECTION);
        conf.putFalse(DMD_USE_TIME_WINDOWS);
        conf.putFalse(DMD_REMOVE_DISJUNCTIVE);
        conf.putFalse(DISJUNCTIVE_FROM_CUMULATIVE_DETECTION);
    }

    public static final void cancelNonSchedulingPreProcess(Configuration conf) {
        conf.putFalse(RESTART_MODE);
        conf.putFalse(INT_EQUALITY_DETECTION);
        conf.putFalse(TASK_EQUALITY_DETECTION);
        conf.putFalse(DISJUNCTIVE_DETECTION);
        conf.putFalse(EXPRESSION_DETECTION);
        conf.putFalse(CLIQUES_DETECTION);
        conf.putFalse(SYMETRIE_BREAKING_DETECTION);
    }

    public static final void keepSchedulingPreProcess(Solver solver) {
        PreProcessConfiguration.cancelNonSchedulingPreProcess(solver.getConfiguration());
    }

    public static final void cancelPreProcess(Configuration conf) {
        PreProcessConfiguration.cancelNonSchedulingPreProcess(conf);
        PreProcessConfiguration.cancelSchedulingPreProcess(conf);
    }

    public static final void cancelPreProcess(Solver solver) {
        PreProcessConfiguration.cancelPreProcess(solver.getConfiguration());
    }
}

