/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TObjectHash<T>
extends THash
implements TObjectHashingStrategy<T> {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient Object[] _set;
    protected TObjectHashingStrategy<T> _hashingStrategy;
    protected static final Object REMOVED = new Object();
    protected static final Object FREE = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy<T> strategy) {
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TObjectHash<T> clone() {
        TObjectHash h = (TObjectHash)super.clone();
        h._set = (Object[])this._set.clone();
        return h;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = REMOVED;
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        Arrays.fill(this._set, FREE);
        return capacity;
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == FREE || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(T obj) {
        TObjectHashingStrategy<Object> hashing_strategy = this._hashingStrategy;
        Object[] set = this._set;
        int length = set.length;
        int hash = hashing_strategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return -1;
        }
        if (cur == REMOVED || !hashing_strategy.equals(cur, obj)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        return cur == FREE ? -1 : index;
    }

    protected int insertionIndex(T obj) {
        TObjectHashingStrategy<Object> hashing_strategy = this._hashingStrategy;
        Object[] set = this._set;
        int length = set.length;
        int hash = hashing_strategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return index;
        }
        if (cur != REMOVED && hashing_strategy.equals(cur, obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && cur != REMOVED && !hashing_strategy.equals(cur, obj));
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == FREE || cur != REMOVED && hashing_strategy.equals(cur, obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != FREE ? -index - 1 : firstRemoved;
        }
        return cur != FREE ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(T o) {
        return o == null ? 0 : o.hashCode();
    }

    @Override
    public final boolean equals(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        if (this._hashingStrategy == this) {
            out.writeObject(null);
        } else {
            out.writeObject(this._hashingStrategy);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        in.readByte();
        this._hashingStrategy = (TObjectHashingStrategy)in.readObject();
        if (this._hashingStrategy == null) {
            this._hashingStrategy = this;
        }
    }
}

