% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxWishart.R
\name{mxWishart}
\alias{mxWishart}
\alias{dmxWishart}
\alias{rmxWishart}
\title{Wishart Distribution}
\usage{
dmxWishart(X, df, S = diag(nrow(X)))

rmxWishart(n, df, S)
}
\arguments{
\item{X}{a \code{(p-by-p)} matrix whose density be computed.}

\item{df}{degrees of freedom}

\item{S}{a \code{(p-by-p)} scale/covariance matrix.}

\item{n}{the number of samples to be generated.}
}
\description{
Functions \code{dmxWishart} and \code{rmxWishart} are for evaluating
densities and generating random samples from corresponding Wishart distribution.
}
\examples{
## generate 10 samples with S=diag(3) with df=10
smW = rmxWishart(10, df=10, S=diag(3))

## evaluate each sample's density
t(apply(smW, 3, dmxWishart, df=10, S=diag(3)))

}
