% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxnorm.R
\name{mxnorm}
\alias{mxnorm}
\alias{dmxnorm}
\alias{rmxnorm}
\title{Matrix Variate Normal Distribution}
\usage{
dmxnorm(X, M = array(0, c(p, n)), U = diag(nrow(M)), V = diag(ncol(M)),
  log = FALSE)

rmxnorm(n, M, U = diag(nrow(M)), V = diag(ncol(M)))
}
\arguments{
\item{X}{a \code{(p-by-n)} matrix whose density be computed.}

\item{M}{a \code{(p-by-n)} mean matrix.}

\item{U}{a \code{(p-by-p)} \emph{left} scale matrix.}

\item{V}{an \code{(n-by-n)} \emph{right} scale matrix.}

\item{log}{a logical; \code{TRUE} to return log density, \code{FALSE} otherwise.}

\item{n}{the number of samples to be generated.}
}
\description{
Functions \code{dmxnorm} and \code{rmxnorm} are for evaluating
densities and generating random samples from corresponding matrix
variate normal distribution.
}
\examples{
## generate 1000 samples from {M,U,V = diag()}
samples1000= rmxnorm(1000, diag(3))

## test for LLN : taking average of 1000 samples
average1000 = apply(samples1000, c(1,2), mean)

## evaluate the density for average matrix
density1000 = dmxnorm(average1000, diag(3))

}
