% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{mathpix}
\alias{mathpix}
\title{Convert an image of an equation to a 'LaTeX' expression}
\usage{
mathpix(img, insert = TRUE, retry = FALSE)
}
\arguments{
\item{img}{image to be converted to LaTeX}

\item{insert}{Should the resulting LaTeX block be inserted into the document (default: TRUE)}

\item{retry}{If Mathpix is not able to process the image, should we try again with
a re-processed image?}
}
\value{
(invisibly) the \code{rmarkdown} LaTeX equation block
}
\description{
Given an image file location, \code{mathpix} performs the relevant
transformations and send the data to the 'Mathpix' API, which returns a
'LaTeX' expression which should generate the typeset equation/expression in
that image. When using 'RStudio', the resulting 'LaTeX' expression is
automatically inserted into the current \code{rmarkdown} document.
}
\details{
You must save your own API key in your
environment (e.g. \verb{~/.Renviron}) with the identifiers \code{MATHPIX_APP_ID} and
\code{MATHPIX_APP_KEY}. This can be tested with \code{mathpix:::credentials()}.
}
\references{
\url{https://mathpix.com/}
}
