% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEqn.R
\name{plotEqn}
\alias{plotEqn}
\title{Plot Linear Equations}
\usage{
plotEqn(A, b, vars, xlim = c(-4, 4), ylim, col = 1:nrow(A), lwd = 2,
  lty = 1, axes = TRUE, labels = TRUE, solution = TRUE)
}
\arguments{
\item{A}{either the matrix of coefficients of a system of linear equations, or the matrix \code{cbind(A,b)}.
The \code{A} matrix must have two columns.}

\item{b}{if supplied, the vector of constants on the right hand side of the equations, of length matching
the number of rows of \code{A}.}

\item{vars}{a numeric or character vector of names of the variables.
If supplied, the length must be equal to the number of unknowns in the equations.
The default is \code{paste0("x", 1:ncol(A)}.}

\item{xlim}{horizontal axis limits for the first variable}

\item{ylim}{vertical axis limits for the second variable; if missing, \code{ylim} is calculated from the
range of the set of equations over the \code{xlim}.}

\item{col}{scalar or vector of colors for the lines, recycled as necessary}

\item{lwd}{scalar or vector of line widths for the lines, recycled as necessary}

\item{lty}{scalar or vector of line types for the lines, recycled as necessary}

\item{axes}{logical; draw horizontal and vertical axes through (0,0)?}

\item{labels}{logical, or a vector of character labels for the equations; if \code{TRUE}, each equation is labeled
using the character string resulting from \code{\link{showEqn}}}

\item{solution}{logical; should the solution points for pairs of equations be marked?}
}
\value{
nothing; used for the side effect of making a plot
}
\description{
Shows what matrices \eqn{A, b} look like as the system of linear equations, \eqn{A x = b} with two unknowns,
x1, x2, by plotting a line for each equation.
}
\examples{
# consistent equations
A<- matrix(c(1,2,3, -1, 2, 1),3,2)
b <- c(2,1,3)
showEqn(A, b)
plotEqn(A,b)

# inconsistent equations
b <- c(2,1,6)
showEqn(A, b)
plotEqn(A,b)
}
\references{
Fox, J. and Friendly, M. (2016). "Visualizing Simultaneous Linear Equations, Geometric Vectors, and
Least-Squares Regression with the matlib Package for R". \emph{useR Conference}, Stanford, CA, June 27 - June 30, 2016.
}
\seealso{
\code{\link{showEqn}}
}
\author{
Michael Friendly
}
