% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jarque.R
\name{jarquebera}
\alias{jarquebera}
\alias{row_jarquebera}
\alias{col_jarquebera}
\title{Jarque-Bera Test}
\usage{
row_jarquebera(x)

col_jarquebera(x)
}
\arguments{
\item{x}{numeric matrix.}
}
\value{
a data.frame where each row contains the results of a Jarque-Bera
test performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs - number of observations\cr
2. skewness - skewness\cr
3. kurtosis - kurtosis\cr
4. df - degrees of freedom\cr
5. statistic - chi-squared statistic\cr
6. pvalue - p-value
}
\description{
Performs a Jarque-Bera goodness of fit test for normality.
}
\details{
\code{row_jarquebera(x)} - Jarque-Bera test on rows.
\code{col_jarquebera(x)} - Jarque-Bera test on columns.

Results should be the same as running \code{moments::jarque.test(x)}
on every row (or column) of \code{x}
}
\examples{
col_jarquebera(iris[,1:4])
row_jarquebera(t(iris[,1:4]))

}
\seealso{
\code{shapiro.test()}
}
\author{
Karolis Koncevičius
}
