% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{pow_byname}
\alias{pow_byname}
\title{Powers of matrix elements}
\usage{
pow_byname(a, pow)
}
\arguments{
\item{a}{a matrix of list of matrices}

\item{pow}{the power to which elements of \code{a} will be raised}
}
\value{
\code{a} with each element raised to \code{pow}
}
\description{
Gives the result of raising all elements of a matrix or list of matrices to a power.
}
\examples{
library(dplyr)
pow_byname(2, 3)
m <- matrix(2, nrow = 2, ncol = 3, dimnames = list(paste0("r", 1:2), paste0("c", 1:3))) \%>\% 
  setrowtype("rows") \%>\% setcoltype("cols")
pow_byname(m, 2)
DF <- data.frame(m = I(list()), pow = I(list()))
DF[[1, "m"]] <- m
DF[[2, "m"]] <- m
DF[[1, "pow"]] <- 0.5
DF[[2, "pow"]] <- -1
DF \%>\% mutate(
  sqrtm = pow_byname(m, 0.5),
  mtopow = pow_byname(m, pow)
)
}
