% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{setrownames_byname}
\alias{setrownames_byname}
\title{Sets row names}
\usage{
setrownames_byname(a, rownames)
}
\arguments{
\item{a}{A matrix or a list of matrices in which row names are to be set}

\item{rownames}{A vector of new row names or a list of vectors of new row names}
}
\value{
a copy of \code{m} with new row names
}
\description{
Sets row names in a way that is amenable to use in piping operations in a functional programming way.
If \code{a} is \code{NULL}, \code{NULL} is returned.
If \code{a} is a constant, it is converted to a matrix and \code{rownames} are applied.
If \code{a} is a matrix, \code{rownames} should be a vector of new row names
that is as long as the number of rows in \code{a}.
If \code{a} is a list of matrices, 
\code{rownames} can also be a list, and it should be as long \code{a}.
Or \code{rownames} can be a vector of row names which will be applied to every matrix in
the list of \code{a}.
Each item in the list should be a vector containing row names for the corresponding 
matrix in \code{a}.
}
\examples{
library(dplyr)
m <- matrix(c(1:6), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 1:3))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
setrownames_byname(m, c("a", "b"))
setrownames_byname(m \%>\% setrowtype("Industries") \%>\% setcoltype("Commodities"), c("c", "d"))
m \%>\% setrownames_byname(NULL)
m \%>\% setrownames_byname(c(NA, NA))
2 \%>\% setrownames_byname("row")
# This also works for lists
setrownames_byname(list(m,m), c("a", "b"))
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
setrownames_byname(DF$m, c("r1", "r2"))
setrownames_byname(DF$m, c("c", "d"))
DF <- DF \%>\% mutate(m = setrownames_byname(m, c("r1", "r2")))
DF$m[[1]]
}
