% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{setcoltype}
\alias{setcoltype}
\title{Sets column type for a matrix or a list of matrices}
\usage{
setcoltype(a, coltype)
}
\arguments{
\item{a}{The matrix on which column type is to be set.}

\item{coltype}{The type of item stored in columns.}
}
\value{
\code{a} with \code{coltype} attribute set.
}
\description{
This function is a wrapper for \code{attr()} so that
setting can be accomplished by the pipe operator (\verb{\%>\%}).
Column types are strings stored in the \code{coltype} attribute.
}
\details{
If \code{is.null(coltype)}, the coltype attribute is deleted
and subsequent calls to \code{coltype} will return \code{NULL}.
}
\examples{
library(dplyr)
commoditynames <- c("c1", "c2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(commoditynames, industrynames))
U \%>\% setcoltype("Industries")
# This also works for lists
setcoltype(list(U,U), coltype = "Industries")
setcoltype(list(U,U), coltype = list("Industries", "Industries"))
DF <- data.frame(U = I(list()))
DF[[1,"U"]] <- U
DF[[2,"U"]] <- U
setcoltype(DF$U, "Industries")
DF <- DF \%>\% mutate(newcol = setcoltype(U, "Industries"))
DF$newcol[[1]]
DF$newcol[[2]]
}
