% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matsindf_apply.R
\name{build_matsindf_apply_data_frame}
\alias{build_matsindf_apply_data_frame}
\title{Create a data frame consisting of the input data for matsindf_apply()}
\usage{
build_matsindf_apply_data_frame(
  .dat = NULL,
  FUN,
  ...,
  types = matsindf_apply_types(.dat, FUN = FUN, ... = ...)
)
}
\arguments{
\item{.dat}{The value of the \code{.dat} argument to \code{matsindf_apply()}, as a list or a data frame.}

\item{FUN}{The function supplied to \code{matsindf_apply()}.}

\item{...}{The \code{...} argument supplied to \code{matsindf_apply()}.}

\item{types}{The types for \code{matsindf_apply()}. Supply if already calculated externally.
Default is \code{types = matsindf_apply_types(.dat, FUN = FUN, ... = ...)}.}
}
\value{
A data frame (actually, a \code{tibble})
with columns from \code{dots}, \code{.dat}, and the default values to \code{FUN},
according to precedence rules for \code{matsindf_apply()}.
}
\description{
This is an internal helper function that takes the types list
and creates a data frame from which calculations
can proceed.
}
\details{
This function enforces the precedence rules for \code{matsindf_apply()}, namely that
variables found in \code{...} take priority over
variables found in \code{.dat}, which take priority over
variables found in the default values of \code{FUN}.
}
