% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dummy.R
\name{add_dummy}
\alias{add_dummy}
\alias{add_dummy_partition}
\title{Additional Predictor as \link[base]{logical}}
\usage{
add_dummy_partition(
  start.model,
  x,
  data = eval(start.model$call$data),
  times,
  mc.cores = switch(.Platform$OS.type, windows = 1L, detectCores()),
  ...
)

add_dummy(
  start.model,
  x,
  data = eval(start.model$call$data),
  mc.cores = switch(.Platform$OS.type, windows = 1L, detectCores()),
  ...
)
}
\arguments{
\item{start.model}{a regression model, e.g.,
\link[stats]{lm}, \link[stats]{glm}, or \link[survival]{coxph}, etc.}

\item{x}{one-sided \link[stats]{formula},
\link[base]{numeric} predictors \eqn{x}'s as the columns of one \link[base]{matrix} column in \code{data}}

\item{data}{(optional) \link[base]{data.frame} in the model \link[base]{call} of \code{start.model}}

\item{times, ...}{additional parameters of function \code{\link[=statusPartition]{statusPartition()}} for function \link{add_dummy_partition}.
For function \code{\link[=add_dummy]{add_dummy()}}, these parameters are not in use}

\item{mc.cores}{\link[base]{integer} scalar, see function \link[parallel]{mclapply}}
}
\value{
Function \code{\link[=add_dummy_partition]{add_dummy_partition()}} returns an object of \link[base]{class} \code{'add_dummy'}, which is a \link[stats]{listof} \link{node1} objects.

Function \code{\link[=add_dummy]{add_dummy()}} returns an object of class \code{'add_dummy'},
which is a \link[stats]{listof} \link{node1} objects.
}
\description{
Additional predictor as \link[base]{logical}.
}
\details{
Function \code{\link[=add_dummy_partition]{add_dummy_partition()}} partitions each additional \link[base]{numeric} predictor
into a \link[base]{logical} variable in the following steps.
\enumerate{
\item {Generate multiple, i.e., repeated, partitions via functions \link[caret]{createDataPartition} or \code{\link[=statusPartition]{statusPartition()}}.}
\item {For each partition, create a dichotomizing rule (via function \code{node1()}) on the training set.
Apply this dichotomizing rule on the test set and obtain the estimated regression coefficient (i.e., effect size)
of the additional \link[base]{logical} predictor.}
\item {Among all partitions, select the one with median effect size of the additional \link[base]{logical} predictor.}
}

Function \code{\link[=add_dummy]{add_dummy()}} partitions each additional
\link[base]{numeric} predictor into a \link[base]{logical} variable
using function \code{\link[=node1]{node1()}},
then \link[stats]{update}s the starting model by adding in each of the dichotomized
\link[base]{logical} predictor.
}
\keyword{internal}
