% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelogram_maze.r
\name{parallelogram_maze}
\alias{parallelogram_maze}
\title{parallelogram_maze .}
\usage{
parallelogram_maze(unit_len, height, width = height, angle = 90,
  clockwise = TRUE, method = c("two_parallelograms", "four_parallelograms",
  "uniform", "random"), start_from = c("midpoint", "corner"), balance = 0,
  draw_boundary = FALSE, num_boundary_holes = 2, boundary_lines = TRUE,
  boundary_holes = NULL, boundary_hole_color = NULL, end_side = 1)
}
\arguments{
\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{height}{the length of the first side in numbers of \code{unit_len}
segments.}

\item{width}{the length of the second side in numbers of \code{unit_len}
segments.}

\item{angle}{the angle (in degrees) between the first and second sides.}

\item{clockwise}{whether to draw clockwise.}

\item{method}{there are many ways to recursive draw an isosceles
trapezoid.  The following values are acceptable:
\describe{
\item{two_parallelograms}{The parallelogram maze is built as two
parallelogram mazes with a holey line between them.}
\item{four_parallelograms}{The parallelogram maze is built as four
parallelogram mazes with three holey lines and one solid line between them.}
\item{uniform}{The parallelogram maze is built as four
parallelogram mazes with three holey lines and one solid line between them.
Sub-mazes are chosen to be nearly equal in size.}
\item{random}{A method is chosen uniformly at random.}
}}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{balance}{for the \code{two_parallelograms} method, we choose whether
to split on height or width based on a balance condition. The log odds
of choosing height over width is the factor \code{balance} times the 
sign of the difference \code{height - width}. When balance takes the default
value of 0, you have equal odds of selecting to split on height or width.
Note that balance is positive and large, you tend to generate nearly
uniform splits. When balance is negative and large, you tend to have
imbalanced mazes, and the imbalance propagates.}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Recursively draw a parallelogram maze, with the first side consisting of
\code{height} segments of length \code{unit_len}, and the second side 
\code{width} segments of length \code{unit_len}. The angle between
the first and second side may be set.
}
\details{
Draws a maze in an parallelogram, starting from the midpoint
of the first side (or the corner before the first side via the
\code{start_from} option). Can recursively subdivide into two or
four parallelograms.  The first (and third) side shall consist of \code{height}
segments of length \code{unit_len}. The second and fourth side consist of
\code{width} segments of length \code{unit_len}. The angle between them is
\code{angle}. Here is an example maze:

\if{html}{
\figure{para-maze-1.png}{options: width="100\%" alt="Figure: parallelogram maze"}
}
\if{latex}{
\figure{para-maze-1.png}{options: width=7cm}
}

This function admits a \code{balance} parameter which controls
how the maze should be recursively subdivided. A negative value creates
imbalanced mazes, while positive values create more uniform mazes. Here are
create seven mazes created side by side with an increasing balance
parameter:

\if{html}{
\figure{para-imbalance-fade-1.png}{options: width="100\%" alt="Figure: parallelogram maze"}
}
\if{latex}{
\figure{para-imbalance-fade-1.png}{options: width=7cm}
}
}
\examples{

library(TurtleGraphics)

turtle_init(500,300,mode='clip')
turtle_hide()
turtle_up()
turtle_do({
 turtle_setpos(15,15)
 turtle_setangle(0)
 parallelogram_maze(angle=90,unit_len=10,width=45,height=25,method='uniform',
 	start_from='corner',draw_boundary=TRUE)
})

# testing imbalance condition
turtle_init(400,500,mode='clip')
turtle_hide()
turtle_up()
turtle_do({
 turtle_setpos(15,250)
 turtle_setangle(0)
 parallelogram_maze(angle=90,unit_len=10,width=30,height=40,
   method='two_parallelograms',draw_boundary=TRUE,balance=-1.0)
})

# a bunch of imbalanced mazes, fading into each other
turtle_init(850,400,mode='clip')
turtle_hide()
turtle_up()
turtle_do({
  turtle_setpos(15,200)
  turtle_setangle(0)
  valseq <- seq(from=-1.5,to=1.5,length.out=4)
  blines <- c(1,2,3,4)
  bholes <- c(1,3)
  set.seed(12354)
  for (iii in seq_along(valseq)) {
     parallelogram_maze(angle=90,unit_len=10,width=20,height=25,
      method='two_parallelograms',draw_boundary=TRUE,balance=valseq[iii],
       end_side=3,boundary_lines=blines,boundary_holes=bholes)
     turtle_right(180)
     blines <- c(2,3,4)
     bholes <- c(3)
  }
})

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
