% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimuminfo.R
\name{MinimumQuantileInformation}
\alias{MinimumQuantileInformation}
\alias{dmqi}
\alias{pmqi}
\alias{qmqi}
\alias{rmqi}
\title{Minimum Quantile Information Distribution}
\usage{
dmqi(x, 
  mqi, 
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL, 
  k = 0.1, 
  intrinsic = NA,
  log = FALSE)

pmqi(q, 
  mqi, 
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL,
  k = 0.1,
  intrinsic = NA,
  lower.tail = TRUE,
  log.p = FALSE
)

qmqi(p, 
  mqi, 
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL, 
  k = 0.1, 
  intrinsic = NA,
  lower.tail = TRUE, 
  log.p = FALSE
)

rmqi(n, 
  mqi, 
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL, 
  k=0.1, 
  intrinsic = NA
)

pmqi(
  q,
  mqi,
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL,
  k = 0.1,
  intrinsic = NA,
  lower.tail = TRUE,
  log.p = FALSE
)

qmqi(
  p,
  mqi,
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL,
  k = 0.1,
  intrinsic = NA,
  lower.tail = TRUE,
  log.p = FALSE
)

rmqi(
  n,
  mqi,
  mqi.quantile = c(0.05, 0.5, 0.95),
  realization = NULL,
  k = 0.1,
  intrinsic = NA
)
}
\arguments{
\item{x, q}{Vector of quantiles}

\item{mqi}{Minimum quantile information}

\item{mqi.quantile}{The quantile of `mqi`. It's a vector of length 3. Default is `c(0.05, 0.5, 0.95)`, 
that is the 5th, 50th and 95th.}

\item{realization}{Default is `NULL`. If not `NULL`, used to define `L` or `U` (see details).}

\item{k}{Overshot, default value is 0.1.}

\item{intrinsic}{Use to specify a prior bounds of the intrinsic range. Default = `NA`.}

\item{log, log.p}{Logical; if `TRUE`, probabilities `p` are given as `log(p)`.}

\item{lower.tail}{Logical; if `TRUE` (default), probabilities are `P[X <= x]` otherwise, `P[X > x]`.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations.}
}
\description{
Density, distribution function, quantile function and random generation
for Minimum Quantile Information distribution.
}
\details{
\eqn{p_1}, \eqn{p_2}, and \eqn{p_3} are percentiles of a distribution with \eqn{p_1 < p_2 < p_3}. 
The interval \eqn{[L,U]} is given with:
\deqn{L = x_{p_{1}}}{L = x_p_1}
\deqn{U = x_{p_{3}}}{U = x_p_3}

The support of minimum quantile information distribution is determined by the intrinsic range:
\deqn{[L^{*}, U^{*}] = [L - k \times (U - L), U + k \times (U - L)]}{[L^*, U^*] = [L - k*(U - L), U + k*(U - L)]}
where \eqn{k} denotes an overshoot and is chosen by the analyst (usually \eqn{k = 10\%}{k = 10\%}, which is the default value).

Given the three values of quantile, \eqn{x_{p_1}}, \eqn{x_{p_2}} and \eqn{x_{p_3}}, 
and define \eqn{p_0 = 0}, \eqn{p_4 = 1}, \eqn{x_{p_0} = L^{*}} and \eqn{x_{p_4} = U^{*}}
the minimum quantile information distribution is given by:

Probability density function 
\deqn{f(x) = \frac{p_{i}-p_{i-1}}{x_{p_{i}}-x_{p_{i-1}}} \text{ for } x_{p_{i-1}} \le x < x_{p_{i}},
 i = 1,\dots,4}{f(x)=(p_i-p_(i-1))/(x_p_i-x_p_(i-1)) for x_p_(i-1)\le x_p_i, i=1,\dots,4}
\deqn{f(x) = 0, \text{ otherwise}}{f(x) = 0, otherwise}

Cumulative distribution function
\deqn{F(x) = 0 \text{ for } x < x_{p_{0}}}{F(x) = 0 for x < x_p_0}
\deqn{F(x) = \frac{p_{i}-p_{i-1}}{x_{p_{i}}-x_{p_{i-1}}}*(x-x_{p_{i-1}})+p_{i-1} \text{ for } x_{p_{i-1}} \le x < x_{p_{i}}, i = 1,\dots,4}{F(x) = (p_i-p_(i-1))/(x_p_i-x_p_(i-1))*(x-x_p_(i-1))+p_(i-1) for x_p_(i-1)\le x_p_i, i=1,\dots,4}

\deqn{F(x) = 1 \text{ for } x_{p_{4}}\le x}{F(x) = 1 for x_p_(4) \le x}



This distribution is usually used for expert elicitation.
If experts have realization information, then the range \eqn{[L,U]} is given by:
\deqn{L = \min(x_{p_{1}}, realization)}{L = min(x_p_1, realization)}
\deqn{U = \max(x_{p_{3}}, realization)}{U = max(x_p_3, realization)}

For some questions, experts may have information for the intrinsic range and set a prior intrinsic range (\eqn{L^*} and \eqn{U^*}).

NOTE that the function is vectorized only for x, q, p, n. As a consequence, it can't be used 
for variable other parameters.
}
\examples{

curve(dmqi(x, mqi=c(40,50,60), intrinsic=c(0,100)), from=0, to=100, type = "l", xlab="x",ylab="pdf")
curve(pmqi(x, mqi=c(40,50,60), intrinsic=c(0,100)), from=0, to=100, type = "l", xlab="x",ylab="cdf")
rmqi(n = 10, mqi=c(555, 575, 586))
}
\references{
Hanea, A. M., & Nane, G. F. (2021). An in-depth perspective on the classical model. In International Series in Operations Research & Management Science (pp. 225–256). Springer International Publishing.
}
\author{
Yu Chen and Arie Havelaar
}
\keyword{distribution}
