% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krige_new.R
\name{krige_new.mcgf_rs}
\alias{krige_new.mcgf_rs}
\title{Obtain kriging forecasts for new locations for an \code{mcgf_rs} object.}
\usage{
\method{krige_new}{mcgf_rs}(
  x,
  newdata = NULL,
  locations_new = NULL,
  dists_new_ls = NULL,
  newdata_new = NULL,
  sds_new_ls = 1,
  newlabel,
  soft = FALSE,
  prob,
  dists_new_base,
  model = c("all", "base"),
  interval = FALSE,
  level = 0.95,
  ...
)
}
\arguments{
\item{x}{An \code{mcgf_rs} object.}

\item{newdata}{A data.frame with the same column names as \code{x}. If \code{newdata}
is missing the forecasts at the original data points are returned.}

\item{locations_new}{A matrix of data.frame of 2D points of new locations,
first column longitude, second column latitude, both in decimal degrees.
Supply only if \code{x} contains \code{locations}. Required when \code{dists_new_ls} is not
supplied.}

\item{dists_new_ls}{List of signed distance matrices (vectors) with names \code{h},
\code{h1}, and 'h2' for all locations(and for each regime), with new locations
in the end. Each matrix must have the same number of columns. Required when
\code{locations_new} is not supplied.}

\item{newdata_new}{Optional; a data.frame with the same number of rows as
\code{newdata}. It contains the data of the new locations.}

\item{sds_new_ls}{List of the standard deviations of the new locations for
each regime. Format must be the same as the output from \code{\link[=sds.mcgf_rs]{sds.mcgf_rs()}}.
Default is 1 for all regimes.}

\item{newlabel}{A vector of new regime labels.}

\item{soft}{Logical; if true, soft forecasts (and bounds) are produced.}

\item{prob}{Matrix with simplex rows. Number of columns must be the same as
unique labels in \code{x}.}

\item{dists_new_base}{Optional, list of distance matrices for the base
model. Used when the base model is non-regime switching. Default is \code{h} from
the first list of \code{dists_new_ls}.}

\item{model}{Which model to use. One of \code{all}, \code{base}, or \code{empirical}.}

\item{interval}{Logical; if TRUE, prediction intervals are computed.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for
the intervals (if any) to be calculated. Used when \code{interval = TRUE}}

\item{...}{Additional arguments.}
}
\value{
A list of kriging forecasts (and prediction intervals) for all
locations.
}
\description{
Obtain kriging forecasts for new locations for an \code{mcgf_rs} object.
}
\details{
It produces simple kriging forecasts for a zero-mean mcgf for new locations
given theri coordinates or relative distances. It supports kriging for the
\code{base} model and the \code{all} model which is the general stationary model with
the base and Lagrangian model from \code{x}.

Users can either supply the coordinates via \code{locations_new}, or a list of
distance for all locations via \code{dists_new_ls}, with new locations at the
end. \code{dists_new_ls} will be used to calculate the new covariance matrices.
When \code{locations_new} is used, make sure \code{x} contains the attribute
\code{locations} of the coordinates of the old locations. When \code{dists_new_ls} is
used, it should be a list of a list of signed distance matrices of the same
dimension, where each row corresponds to the relative distances between a new
location and old locations in the same order as they appear in \code{x}. If only
one list is provided, it will be used for all regimes.

When \code{soft = TRUE}, \code{prob} will be used to compute the soft forecasts
(weighted forecasts). The number of columns must match the number of unique
levels in \code{x}. The column order must be the same as the order of regimes as
in \code{levels(attr(x, "label", exact = TRUE))}. If not all regimes are seen in
\code{newlabel}, then only relevant columns in \code{prob} are used.

When \code{interval = TRUE}, confidence interval for each forecasts and each
horizon is given. Note that it does not compute confidence regions.
}
\examples{
data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data,
    locations = sim2$locations,
    label = sim2$label
)
sim2_mcgf <- add_acfs(sim2_mcgf, lag_max = 5)
sim2_mcgf <- add_ccfs(sim2_mcgf, lag_max = 5)

# Fit a regime-switching separable model
fit_sep <- fit_base(
    sim2_mcgf,
    lag_ls = 5,
    model_ls = "sep",
    par_init_ls = list(list(
        c = 0.00005,
        gamma = 0.5,
        a = 0.5,
        alpha = 0.5
    )),
    par_fixed_ls = list(c(nugget = 0))
)

# Store the fitted separable models to 'sim2_mcgf'
sim2_mcgf <- add_base(sim2_mcgf, fit_base_ls = fit_sep)

# Calculate the simple kriging predictions and intervals for all locations
locations_new <- rbind(c(-110, 55), c(-109, 54))
sim2_krige <- krige_new(sim2_mcgf,
    locations_new = locations_new,
    model = "base", interval = TRUE
)
}
\seealso{
Other functions on fitting an mcgf_rs: 
\code{\link{add_base.mcgf_rs}()},
\code{\link{add_lagr.mcgf_rs}()},
\code{\link{fit_base.mcgf_rs}()},
\code{\link{fit_lagr.mcgf_rs}()},
\code{\link{krige.mcgf_rs}()}
}
\concept{functions on fitting an mcgf_rs}
