% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_matrix_linear_predictor.R
\name{mc_matrix_linear_predictor}
\alias{mc_matrix_linear_predictor}
\title{Matrix Linear Predictor}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.

Bonat, W. H. and Jorgensen, B. (2016) Multivariate
    covariance generalized linear models.
    Journal of Royal Statistical Society - Series C 65:649--675.
}
\usage{
mc_matrix_linear_predictor(tau, Z)
}
\arguments{
\item{tau}{a numeric vector of dispersion parameters.}

\item{Z}{a list of known matrices.}
}
\value{
A matrix.
}
\description{
Compute the matrix linear predictor. It is an internal
function, however, since the concept of matrix linear predictor
was proposed recently. I decided let this function visible to the
interested reader gets some feeling about how it works.
}
\details{
Given a list with a set of known matrices
    (\eqn{Z_0,...,Z_D}) the function \cr
    \code{mc_matrix_linear_predictor} returns \eqn{U = \tau_0 Z_0 +
    ... + \tau_D Z_D}.
}
\examples{
require(Matrix)
Z0 <- Diagonal(5, 1)
Z1 <- Matrix(rep(1,5)\%*\%t(rep(1,5)))
Z <- list(Z0, Z1)
mc_matrix_linear_predictor(tau = c(1,0.8), Z = Z)
}
\seealso{
\code{mc_id}, \code{mc_dist}, \code{mc_ma}, \code{mc_rw},
\code{mc_mixed} and \code{mc_car}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
