% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef}
\alias{coef}
\alias{coef.mcarray}
\alias{coef.mcmc}
\alias{coef.mcmc.list}
\alias{coef.mcmcarray}
\alias{coef.mcmcr}
\title{Term Coefficients}
\usage{
\method{coef}{mcarray}(object, conf_level = 0.95,
  estimate = stats::median, ...)

\method{coef}{mcmc}(object, conf_level = 0.95,
  estimate = stats::median, ...)

\method{coef}{mcmc.list}(object, conf_level = 0.95,
  estimate = stats::median, ...)

\method{coef}{mcmcarray}(object, conf_level = 0.95,
  estimate = stats::median, ...)

\method{coef}{mcmcr}(object, conf_level = 0.95,
  estimate = stats::median, ...)
}
\arguments{
\item{object}{The MCMC object to get the coefficients for}

\item{conf_level}{A number specifying the confidence level. By default 0.95.}

\item{estimate}{The function to use to calculate the estimate.}

\item{...}{Unused}
}
\value{
An data frame of the coefficients with the columns indicating the
\code{term}, \code{estimate}, standard deviation (\code{sd}), \code{zscore},
\code{lower} and \code{upper} credible intervals and \code{pvalue}.
}
\description{
Gets coefficients for all the terms in an MCMC object.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcarray}: Get coefficients for terms in mcarray object

\item \code{mcmc}: Get coefficients for terms in mcmc object

\item \code{mcmc.list}: Get coefficients for terms in mcmc.list object

\item \code{mcmcarray}: Get coefficients for terms in mcmcarray object

\item \code{mcmcr}: Get coefficients for terms in mcmcr object
}}

\examples{
coef(mcmcr_example)
}
\seealso{
\code{stats::\link[stats]{coef}}
}
