% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset.term}
\alias{subset.mcmc}
\alias{subset.mcmc.list}
\alias{subset.mcmcarray}
\alias{subset.mcmcr}
\alias{subset.mcmcrs}
\title{Subset an MCMC Object}
\usage{
\method{subset}{term}(x, parameters = NULL, ...)

\method{subset}{mcmc}(x, iterations = NULL, parameters = NULL, ...)

\method{subset}{mcmc.list}(x, chains = NULL, iterations = NULL,
  parameters = NULL, ...)

\method{subset}{mcmcarray}(x, chains = NULL, iterations = NULL, ...)

\method{subset}{mcmcr}(x, chains = NULL, iterations = NULL,
  parameters = NULL, ...)

\method{subset}{mcmcrs}(x, chains = NULL, iterations = NULL,
  parameters = NULL, ...)
}
\arguments{
\item{x}{The MCMC object to subset}

\item{parameters}{A character vector (or NULL) of the parameters to subset by.}

\item{...}{Unused}

\item{iterations}{An integer vector (or NULL) of the iterations to subset by.}

\item{chains}{An integer vector (or NULL) of the chains to subset by.}
}
\description{
Subsets an MCMC object by its chains, iterations and/or parameters.
}
\section{Methods (by class)}{
\itemize{
\item \code{term}: Subset a term vector

\item \code{mcmc}: Subset an mcmc object

\item \code{mcmc.list}: Subset an mcmc.list object

\item \code{mcmcarray}: Subset an mcmcarray object

\item \code{mcmcr}: Subset an mcmcr object

\item \code{mcmcrs}: Subset an mcmcrs object
}}

\examples{
subset(mcmcr_example, chains = 2L, iterations = 1:100,
  parameters = c("beta", "alpha"))
}
