% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{par_names}
\alias{par_names}
\title{Get the parameter names from a draws object}
\usage{
par_names(draws)
}
\arguments{
\item{draws}{a draws object.}
}
\value{
The names of the parameters whose MCMC simulations are stored in \code{draws}.
}
\description{
Get the parameter names from a draws object
}
\examples{
data(iris)
sampler <- create_sampler(Sepal.Length ~ 
    reg(~ Petal.Length + Species, name="beta"), data=iris)
sim <- MCMCsim(sampler, burnin=100, n.iter=500)
(summary(sim))
par_names(sim)

}
