% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{MCMC-object-conversion}
\alias{MCMC-object-conversion}
\alias{to_mcmc}
\alias{to_draws_array}
\alias{as.array.dc}
\alias{as.matrix.dc}
\title{Convert a draws component object to another format}
\usage{
to_mcmc(x)

to_draws_array(x, components = NULL)

\method{as.array}{dc}(x, ...)

\method{as.matrix}{dc}(x, colnames = TRUE, ...)
}
\arguments{
\item{x}{a component of an mcdraws object corresponding to a scalar or vector model parameter.}

\item{components}{optional character vector of names of draws components in an mcdraws object.
This can be used to select a subset of components to convert to
 \code{\link[posterior]{draws_array}} format.}

\item{...}{currently ignored.}

\item{colnames}{whether column names should be set.}
}
\value{
The draws component(s) coerced to an \code{\link[coda]{mcmc.list}} object,
 a \code{\link[posterior]{draws_array}} object, an array, or a matrix.
}
\description{
Use \code{to_mcmc} to convert a draws component to class \code{\link[coda]{mcmc.list}},
allowing one to use MCMC diagnostic functions provided by package \pkg{coda}.
Use \code{as.array} to convert to an array of dimension \code{(draws, chains, parameters)}.
The array format is supported by some packages for analysis or visualisation of MCMC
simulation results, e.g. \pkg{bayesplot}.
Use \code{as.matrix} to convert to a matrix, concatenating the chains.
Finally, use \code{to_draws_array} to convert either a draws component or
(a subset of components of) an mcdraws object to a \code{draws_array} object
as defined in package \pkg{posterior}.
}
\examples{
\donttest{
data(iris)
sampler <- create_sampler(Sepal.Length ~ reg(~ Petal.Length + Species, name="beta"), data=iris)
sim <- MCMCsim(sampler, burnin=100, n.chain=2, n.iter=400)
summary(sim)
if (require("coda", quietly=TRUE)) {
  mcbeta <- to_mcmc(sim$beta)
  geweke.diag(mcbeta)
}
if (require("posterior", quietly=TRUE)) {
  mcbeta <- to_draws_array(sim$beta)
  mcbeta
  draws <- to_draws_array(sim)
  str(draws)
}
str(as.array(sim$beta))
str(as.matrix(sim$beta))

# generate some example data
n <- 250
dat <- data.frame(x=runif(n), f=as.factor(sample(1:5, n, replace=TRUE)))
gd <- generate_data(~ reg(~ x + f, prior=pr_normal(precision=1), name="beta"), data=dat)
dat$y <- gd$y
sampler <- create_sampler(y ~ reg(~ x + f, name="beta"), data=dat)
sim <- MCMCsim(sampler, n.chain=2, n.iter=400)
str(sim$beta)
str(as.array(sim$beta))
bayesplot::mcmc_hist(as.array(sim$beta))
bayesplot::mcmc_dens_overlay(as.array(sim$beta))
# fake data simulation check:
bayesplot::mcmc_recover_intervals(as.array(sim$beta), gd$pars$beta)
bayesplot::mcmc_recover_hist(as.array(sim$beta), gd$pars$beta)

ex <- mcmcsae_example()
plot(ex$dat$fT, ex$dat$y)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, n.chain=2, n.iter=400, store.all=TRUE)
str(sim$beta)
str(as.matrix(sim$beta))
# fake data simulation check:
bayesplot::mcmc_recover_intervals(as.matrix(sim$beta), ex$pars$beta)
bayesplot::mcmc_recover_intervals(as.matrix(sim$u), ex$pars$u)
}

}
