% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelmatrix.R
\name{model_matrix}
\alias{model_matrix}
\title{Compute possibly sparse model matrix}
\usage{
model_matrix(
  formula,
  data = NULL,
  contrasts.arg = NULL,
  drop.unused.levels = FALSE,
  sparse = NULL,
  drop0 = TRUE,
  catsep = "",
  by = NULL,
  tabM = FALSE
)
}
\arguments{
\item{formula}{model formula.}

\item{data}{data frame containing all variables used in \code{formula}.
These variables should not contain missing values. An error is raised in case any of them does.}

\item{contrasts.arg}{specification of contrasts for factor variables. Currently supported are
"contr.none" (no contrasts applied), "contr.treatment" (first level removed) and "contr.SAS" (last level removed).
Alternatively, a named list specifying a single level per factor variable can be passed.}

\item{drop.unused.levels}{whether empty levels of individual factor variables should be removed.}

\item{sparse}{if \code{TRUE} a sparse matrix of class \code{dgCMatrix} is returned. This can be efficient
for large datasets and a model containing categorical variables with many categories. If \code{sparse=NULL}, the default,
whether a sparse or dense model matrix is returned is based on a simple heuristic.}

\item{drop0}{whether to drop any remaining explicit zeros in resulting sparse matrix.}

\item{catsep}{separator for concatenating factor variable names and level names.
By default it is the empty string, reproducing the labels of \code{model.matrix}.}

\item{by}{a vector by which to aggregate the result.}

\item{tabM}{if \code{TRUE} return a list of tabMatrix objects.}
}
\value{
Design matrix X, either an ordinary matrix or a sparse \code{dgCMatrix}.
}
\description{
Compute possibly sparse model matrix
}
