% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcse.R
\name{mcse.mat}
\alias{mcse.mat}
\title{Apply \code{mcse} to each column of the MCMC samples.}
\usage{
mcse.mat(x, size = NULL, g = NULL, method = "bm", r = 3)
}
\arguments{
\item{x}{a matrix of values from a Markov chain of size n x p.}

\item{size}{represents the batch size in \dQuote{\code{bm}} and the truncation point in \dQuote{\code{bartlett}} and 
\dQuote{\code{tukey}}. Default is \code{NULL} which implies that an optimal batch size is calculated using the 
  \code{batchSize} function. Can take character values of \dQuote{\code{sqroot}} and \dQuote{\code{cuberoot}} or any numeric
  value between 1 and n/2. \dQuote{\code{sqroot}} means size is \eqn{\lfloor n^{1/2} \rfloor} and \dQuote{\code{cuberoot}} means size is
  \eqn{\lfloor n^{1/3} \rfloor}.}

\item{g}{a function such that \eqn{E(g(x))} is the quantity of interest. The default is
\code{NULL}, which causes the identity function to be used.}

\item{method}{any of \dQuote{\code{bm}},\dQuote{\code{obm}},\dQuote{\code{bartlett}}, \dQuote{\code{tukey}}. \dQuote{\code{bm}}
represents batch means estimator, \dQuote{\code{obm}} represents overlapping batch means estimator with, \dQuote{\code{bartlett}}
and \dQuote{\code{tukey}} represents the modified-Bartlett window and the Tukey-Hanning windows for spectral variance estimators.}

\item{r}{The lugsail parameters (\code{r}) that converts a lag window into its lugsail
equivalent. Larger values of \code{r} will typically imply less underestimation of \dQuote{\code{cov}},
but higher variability of the estimator. Default is \code{r = 3} and \code{r = 1,2} are
also good choices although may lead to underestimates of the variance. \code{r > 5} is not recommended.}
}
\value{
\code{mcse.mat} returns a matrix with \code{ncol(x)} rows and two columns. The row names
  of the matrix are the same as the column names of \code{x}. The column names of the matrix are
  \dQuote{\code{est}} and \dQuote{\code{se}}. The \eqn{j}th row of the matrix contains the result
  of applying \code{mcse} to the \eqn{j}th column of \code{x}.
}
\description{
Apply \code{mcse} to each column of the MCMC samples.
}
\seealso{
\code{\link{mcse}}, which acts on a vector.

\code{\link{mcse.multi}}, for a multivariate estimate of the Monte Carlo standard error.

\code{\link{mcse.q}} and \code{\link{mcse.q.mat}}, which compute standard errors for quantiles.
}
