% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_relative_rmse}
\alias{calc_relative_rmse}
\title{Calculate Relative Root Mean Squared Error and its Monte Carlo Standard Error}
\usage{
calc_relative_rmse(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.
Note that `true_param` must not be zero, as the calculation involves division by the true parameter value.}
}
\value{
A list with two components: `rel_rmse`, the calculated Relative Root Mean Squared Error of the
estimates, and `rel_rmse_mcse`, the Monte Carlo Standard Error of the Relative RMSE. The MCSE is
currently not calculated and returned as `NA`. This is a placeholder for future implementation.
}
\description{
Computes the Relative Root Mean Squared Error (Relative RMSE) of a set of estimates with respect
to a true parameter value. The Relative RMSE is derived from the Relative Mean Squared Error (MSE),
providing a scale-independent measure of error that facilitates comparisons across different scales
of the true parameter. This function is especially useful for evaluating the accuracy of estimates
when the magnitude of the true parameter varies significantly across different scenarios. The function
gracefully handles cases where the true parameter is zero by returning `NA` for both Relative RMSE
and its MCSE, to avoid division by zero. The MCSE for the Relative RMSE is not directly computed
in this function and is marked as a placeholder for future implementation.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50 # Non-zero true parameter
relative_rmse_info <- calc_relative_rmse(estimates, true_param)
print(relative_rmse_info)
}
