% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_mctq.R
\docType{data}
\name{micro_mctq}
\alias{micro_mctq}
\title{A fictional \eqn{\mu}MCTQ dataset}
\format{
A tibble with 17 columns and
50` rows:

\describe{
\item{id}{
A unique \code{integer} value to identify each respondent in the dataset.
\cr \cr
Type: Control.
\cr \cr
R class: \code{integer}.}

\item{shift_work}{
A \code{logical} value indicating if the respondent has been a shift- or
night-worker in the past three months.
\cr \cr
Statement (\code{EN}): "I have been a shift- or night-worker in the past three
months: Yes ( ___ ) No ( ___ )".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{logical}.}

\item{wd}{
Number of \strong{workdays} per week.
\cr \cr
Statement (\code{EN}): "Normally, I work ___ days/week".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{integer}.}

\item{fd}{
Number of \strong{work-free days} per week.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{integer}.}

\item{so_w}{
Local time of sleep onset on \strong{workdays}.
\cr \cr
Statement (\code{EN}): "On WORKDAYS ... I normally fall asleep at ___ : ___
AM/PM (this is NOT when you get into bed, but rather when you fall
asleep)".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{hms}.}

\item{se_w}{
Local time of sleep end on \strong{workdays}.
\cr \cr
Statement (\code{EN}): "On WORKDAYS ... I normally wake up at ___ : ___ AM/PM
(this is NOT when you get out of bed, but rather when you wake up)".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{hms}.}

\item{sd_w}{
Sleep duration on \strong{workdays}.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}

\item{msw}{
Local time of mid-sleep on \strong{workdays}.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{hms}.}

\item{so_f}{
Local time of sleep onset on \strong{work-free days} when the respondent
\strong{doesn't} use an alarm clock to wake up.
\cr \cr
Statement (\code{EN}): "On WORK-FREE DAYS when I DON'T use an alarm clock ... I
normally fall asleep at ___ : ___ AM/PM (this is NOT when you get into bed,
but rather when you fall asleep)".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{hms}.}

\item{se_f}{
Local time of sleep end on \strong{work-free days} when the respondent
\strong{doesn't} use an alarm clock to wake up.
\cr \cr
Statement (\code{EN}): "On WORK-FREE DAYS when I DON'T use an alarm clock ... I
normally wake up at ___ : ___ AM/PM (this is NOT when you get out of bed,
but rather when you wake up)".
\cr \cr
Type: Basic.
\cr \cr
R class: \code{hms}.}

\item{sd_f}{
Sleep duration on \strong{work-free days} when the respondent \strong{doesn't} use an
alarm clock to wake up.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}

\item{msf}{
Local time of mid-sleep on \strong{work-free days} when the respondent
\strong{doesn't} use an alarm clock to wake up.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{hms}.}

\item{sd_week}{
Average weekly sleep duration.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}

\item{sloss_week}{
Weekly sleep loss.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}

\item{msf_sc}{
Chronotype or corrected local time of mid-sleep on \strong{work-free days}.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{hms}.}

\item{sjl_rel}{
Relative social jetlag.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}

\item{sjl}{
Absolute social jetlag.
\cr \cr
Type: Computed.
\cr \cr
R class: \code{Duration}.}
}
}
\source{
Created by Daniel Vartanian (package author).
}
\usage{
micro_mctq
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A fictional dataset, \strong{for testing and learning purposes}, composed of
basic/measurable and computed variables of the Munich Chronotype
Questionnaire (MCTQ) micro version.

This data was created following the guidelines in Ghotbi \emph{et.al} (2020), in
addition to the guidelines in Roenneberg, Wirz-Justice, & Merrow (2003),
Roenneberg, Allebrandt, Merrow, & Vetter (2012), and The Worldwide
Experimental Platform (n.d.). See the References and Details sections
to learn more.
}
\details{
\code{micro_mctq} is a tidied, validated, and transformed version of
\code{raw_data("micro_mctq.csv")}.
\subsection{Guidelines}{

To learn more about the Munich Chronotype Questionnaire (MCTQ),
see Roenneberg, Wirz-Justice, & Merrow (2003), Roenneberg, Allebrandt,
Merrow, & Vetter (2012), Roenneberg et al. (2015), and Roenneberg, Pilz,
Zerbini, & Winnebeck (2019).

To know about different MCTQ versions, see Juda, Vetter, & Roenneberg
(2013) and Ghotbi et.al (2020).

If you're curious about the variable computations and want to have access to
the full questionnaire, see The Worldwide Experimental Platform (n.d.).
}

\subsection{Data building and data wrangling}{

This dataset was created by randomized sampling (see \code{\link[=random_mctq]{random_mctq()}})
and by manual insertions of special cases. Its purpose is to demonstrate
common cases and data issues that researchers may find in their MCTQ data, in
addition to be a suggested data structure for MCTQ data.

You can see the \code{micro_mctq} build and data wrangling processes
\href{https://github.com/ropensci/mctq/blob/master/data-raw/micro_mctq.R}{here}.
}

\subsection{Variable naming}{

The naming of the variables took into account the naming scheme used in MCTQ
publications, in addition to the guidelines of the \href{https://style.tidyverse.org/}{tidyverse style guide}.
}

\subsection{Variable classes}{

The \code{mctq} package works with a set of object classes specially created to
hold time values. These classes can be found in the \link[hms:hms-package]{hms}
and \link[lubridate:lubridate-package]{lubridate} package.
}

\subsection{\code{Duration} objects}{

If you prefer to view \code{Duration} objects as \code{hms} objects, run
\code{pretty_mctq(micro_mctq)}.
}
}
\references{
Ghotbi, N., Pilz, L. K., Winnebeck, E. C., Vetter, C., Zerbini, G., Lenssen,
D., Frighetto, G., Salamanca, M., Costa, R., Montagnese, S., & Roenneberg, T.
(2020). The \eqn{\mu}MCTQ: an ultra-short version of the Munich ChronoType
Questionnaire. \emph{Journal of Biological Rhythms}, \emph{35}(1), 98-110.
\doi{10.1177/0748730419886986}.

Juda, M., Vetter, C., & Roenneberg, T. (2013). The Munich ChronoType
Questionnaire for shift-workers (MCTQ\eqn{^{Shift}}{ Shift}). \emph{Journal of
Biological Rhythms}, \emph{28}(2), 130-140. \doi{10.1177/0748730412475041}.

Roenneberg T., Allebrandt K. V., Merrow M., & Vetter C. (2012). Social jetlag
and obesity. \emph{Current Biology}, \emph{22}(10), 939-43.
\doi{10.1016/j.cub.2012.03.038}.

Roenneberg, T., Keller, L. K., Fischer, D., Matera, J. L., Vetter, C., &
Winnebeck, E. C. (2015). Human activity and rest in situ. In A. Sehgal (Ed.),
\emph{Methods in Enzymology} (Vol. 552, pp. 257-283). London, UK: Academic Press.
\doi{10.1016/bs.mie.2014.11.028}.

Roenneberg, T., Pilz, L. K., Zerbini, G., & Winnebeck, E. C. (2019).
Chronotype and social jetlag: a (self-) critical review. \emph{Biology}, \emph{8}(3),
54. \doi{10.3390/biology8030054}.

Roenneberg, T., Wirz-Justice, A., & Merrow, M. (2003). Life between clocks:
daily temporal patterns of human chronotypes. \emph{Journal of Biological
Rhythms}, \emph{18}(1), 80-90. \doi{10.1177/0748730402239679}.

The Worldwide Experimental Platform (n.d.). MCTQ.
\url{https://www.thewep.org/documentations/mctq/}
}
\seealso{
Other datasets: 
\code{\link{shift_mctq}},
\code{\link{std_mctq}}
}
\concept{datasets}
\keyword{datasets}
