% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_mc.R
\name{expect_mc_iid_chisq}
\alias{expect_mc_iid_chisq}
\title{Test iid samples for correct cdf using chisq test}
\usage{
expect_mc_iid_chisq(object, prob, control = NULL)
}
\arguments{
\item{object}{A function taking one argument - that generates n univariate iid samples.}

\item{prob}{A vector of probabilities for finitely many consecutive integers from 0 onwards.}

\item{control}{a list controlling the algorithm
\itemize{
\item n number of samples to be taken in the first step. Default: 1e3
\item maxseqsteps: Number of sequential attempts to use. Default: 7.
\item incn: Factor by which to multiply n from the second  sequential attempt onwards. Default: 4.
\item level: bound on the type I error, ie the probability of wrongly rejecting a sampler with the correct distribution. Default: 1e-5.
\item debug: If positive  then debug information will be printed via 'message()'. Default: 0.
}}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Test if samples are behaving like an iid sample from a given distribution
via the chisq test and a sequential approach. Only works for
discrete distributions taking finitely many values.
}
\examples{
   sampler <- function(n) rbinom(n,prob=0.6,size=5)
   expect_mc_iid_chisq(sampler, dbinom(0:5,prob=0.6,size=5))
   testthat::expect_error(expect_mc_iid_chisq(sampler, dbinom(0:5,prob=0.63,size=5)))

}
