% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcrals.R
\name{mcrals.nnls}
\alias{mcrals.nnls}
\title{Non-negative least squares}
\usage{
mcrals.nnls(
  D,
  A,
  tol = 10 * .Machine$double.eps * as.numeric(sqrt(crossprod(A[, 1]))) * nrow(A)
)
}
\arguments{
\item{D}{a matrix}

\item{A}{a matrix}

\item{tol}{tolerance parameter for algorithm convergence}
}
\description{
Non-negative least squares
}
\details{
Computes NNLS solution for B: D = AB' subject to B >= 0. Implements
the active-set based algorithm proposed by Lawson and Hanson [1].
}
\references{
1.  Lawson, Charles L.; Hanson, Richard J. (1995). Solving Least Squares Problems. SIAM.
}
