% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdftracks.R
\name{read.mdf}
\alias{read.mdf}
\title{Read an MTrackJ Data File (\code{.mdf})}
\usage{
read.mdf(file, drop.Z = F, include.point.numbers = FALSE,
  include.channel = F, generate.unique.ids = F, text, fileEncoding = "")
}
\arguments{
\item{file}{MTrackJ Data File (\code{.mdf}) file with tracking data.}

\item{drop.Z}{drop z-coordinate (for 2D data)}

\item{include.point.numbers}{include the point numbers in the mdf file
(\strong{NB} these can be different from the time/frame points)}

\item{include.channel}{include channel information}

\item{generate.unique.ids}{combine cluster and id columns to get unique ids}

\item{text}{character string: if file is not supplied and this is, then data
are read from the value of text via a text connection. Notice that a literal
string can be used to include (small) data sets within R code.}

\item{fileEncoding}{character string: if non-empty declares the encoding to
be used on a file (not a connection) so the character data can be re-encoded
as they are written. See \code{\link[base:file]{base::file()}}.}
}
\description{
Reads an MTrackJ Data File (\code{.mdf}) file in a data.frame.
}
\examples{
read.mdf(system.file("extdata", "example.mdf", package = 'mdftracks'))

}
\seealso{
\href{https://imagescience.org/meijering/software/mtrackj/format/}{MTrackJ Data Format}

Other mdftracks functions: \code{\link{write.mdf}}
}
