% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOrder.R
\name{findOrder}
\alias{findOrder}
\title{Find order}
\usage{
findOrder(X, dist = "euclidean", linkage = "complete")
}
\arguments{
\item{X}{Matrix.}

\item{dist}{Distance used when defining a distance matrix of X.}

\item{linkage}{Type of linkage used in the hierarchical clustering of X.}
}
\value{
The order of the rows of X based on a hierarchical clustering.
}
\description{
Find the ordering of the rows of X based on a hierarchical
clustering of X for linkage ``linkage`` and distance ``dist``.
}
\examples{

N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
findOrder(X)

}
