% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Violations}
\alias{Violations}
\alias{ViolationCodes}
\alias{Cuisines}
\title{NYC Restaurant Health Violations}
\format{{
A data frame with 480,621 observations on the following 16 variables.
\describe{
 \item{\code{camis}}{unique identifier}
 \item{\code{dba}}{full name doing business as}
 \item{\code{boro}}{borough of New York}
 \item{\code{building}}{building name}
 \item{\code{street}}{street address}
 \item{\code{zipcode}}{zipcode}
 \item{\code{phone}}{phone number}
 \item{\code{inspection_date}}{inspection date}
 \item{\code{action}}{action taken}
 \item{\code{violation_code}}{violation code, see \code{\link{ViolationCodes}}}
 \item{\code{score}}{inspection score}
 \item{\code{grade}}{inspection grade}
 \item{\code{grade_date}}{grade date}
 \item{\code{record_date}}{recording date}
 \item{\code{inspection_type}}{inspect type}
 \item{\code{cuisine_code}}{cuisine code, see \code{\link{Cuisines}}}
}
}}
\source{
NYC Open Data, \url{https://data.cityofnewyork.us/Health/DOHMH-New-York-City-Restaurant-Inspection-Results/43nn-pn8j}
}
\usage{
Violations

ViolationCodes

Cuisines
}
\description{
NYC Restaurant Health Violations
}
\examples{
data(Violations)
Violations \%>\%
  inner_join(Cuisines, by = "cuisine_code") \%>\%
  filter(cuisine_description == "American") \%>\%
  arrange(grade_date) \%>\%
  head() 
}
\seealso{
\code{\link{ViolationCodes}}, \code{\link{Cuisines}}
}
\keyword{datasets}
