% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_md_theme.R
\name{as_md_theme}
\alias{as_md_theme}
\title{Turn a Usual Theme into a Markdown Theme}
\usage{
as_md_theme(theme, all_plain = TRUE)
}
\arguments{
\item{theme}{An object of class \code{theme}}

\item{all_plain}{\code{logical}. Should all text be plain by default?}
}
\value{
An object of class \code{theme} that can be added to any \code{ggplot}
}
\description{
Transform any \code{{ggplot2}} theme into a theme that renders text as markdown
}
\examples{
library(ggplot2)
data(mtcars)

# Create a custom theme
my_theme <- theme_gray() +
  theme(
    panel.grid.minor = element_blank(),
    panel.grid.major = element_blank()
  )
p <- ggplot(mtcars, aes(hp)) +
  geom_histogram() +
  ggtitle("Mixing **bold** and *italics* is easy")

# Text is not rendered
p + my_theme

# Text is rendered properly
p + as_md_theme(my_theme)

}
