% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_multiclass.R
\name{LSR}
\alias{LSR}
\title{Logarithmic Scoring Rule}
\usage{
LSR(probabilities, truth)
}
\arguments{
\item{probabilities}{[numeric] vector (or matrix with column names of the classes) of predicted probabilities}

\item{truth}{vector of true values 
n = 20
set.seed(122)
truth = as.factor(sample(c(1,2,3), n, replace = TRUE))
probabilities = matrix(runif(60), 20, 3)
probabilities = probabilities/rowSums(probabilities)
colnames(probabilities) = c(1,2,3)
LSR(probabilities, truth)}
}
\description{
Defined as: mean(log(p_i)), where p_i is the predicted probability of the true class of observation i.
This scoring rule is the same as the negative logloss, self-information or surprisal.
See: Bickel, J. E. (2007). Some comparisons among quadratic, spherical, and logarithmic scoring rules. Decision Analysis, 4(2), 49-65.
}
