% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/stand_metrics.R
\name{stand_basalArea}
\alias{stand_basalArea}
\alias{stand_foliarBiomass}
\alias{stand_phytovolume}
\alias{stand_fuel}
\alias{stand_LAI}
\alias{stand_values}
\alias{stand_dominantTreeDiameter}
\alias{stand_dominantTreeHeight}
\alias{stand_hartBeckingIndex}
\alias{stand_quadraticMeanTreeDiameter}
\title{Stand values}
\usage{
stand_basalArea(x, minDBH = 7.5)

stand_foliarBiomass(x, SpParams, gdd = NA_real_, mode = "MED")

stand_phytovolume(x, SpParams)

stand_fuel(x, SpParams, gdd = NA_real_, includeDead = TRUE, mode = "MED")

stand_LAI(x, SpParams, gdd = NA_real_, mode = "MED", bounded = TRUE)

stand_dominantTreeDiameter(x, minDBH = 7.5)

stand_dominantTreeHeight(x, minDBH = 7.5)

stand_hartBeckingIndex(x, minDBH = 7.5)

stand_quadraticMeanTreeDiameter(x, minDBH = 7.5)
}
\arguments{
\item{x}{An object of class \code{\link{forest}}.}

\item{minDBH}{Minimum diameter at breast height (in cm) to include in estimation.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{gdd}{Growth degree days (to account for leaf phenology effects).}

\item{mode}{Calculation mode, either "MED" or "US".}

\item{includeDead}{A flag to indicate that standing dead fuels (dead branches) are included.}

\item{bounded}{A boolean flag to indicate that extreme values should be prevented (maximum tree LAI = 7 and maximum shrub LAI = 3)}
}
\value{
\itemize{
\item{\code{stand_basalArea}: Stand basal area (m2/ha).}
\item{\code{stand_dominantTreeDiameter}: Dominant tree diameter, i.e the average diameter of the 100 widest trees (in cm).}
\item{\code{stand_quadraticMeanTreeDiameter}: Quadratic mean tree diameter, i.e. the diameter value corresponding to the current basal area and density.}
\item{\code{stand_dominantTreeHeight}: Dominant tree height, i.e the average height of the 100 tallest trees (in cm).}
\item{\code{stand_hartBeckingIndex}: Hart becking index.}
\item{\code{stand_foliarBiomass}: Standing biomass of leaves (in kg/m2).}
\item{\code{stand_fuel}: Stand fine fuel load (in kg/m2).}
\item{\code{stand_LAI}: Stand leaf area index (m2/m2).}
\item{\code{stand_phytovolume}: Stand shrub phytovolume (m3/m2).}
}
}
\description{
Functions to calculate stand attributes of a \code{\link{forest}} object.
}
\examples{
#Default species parameterization
data(SpParamsMED)
  
#Load example plot
data(exampleforestMED)
    
#A short way to obtain total basal area
stand_basalArea(exampleforestMED)
    
}
\seealso{
\code{\link{forest}}, \code{\link{plant_basalArea}}, \code{\link{summary.forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
