% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{aspwbInput}
\alias{aspwbInput}
\alias{aspwb_day}
\alias{aspwb}
\title{Simulation in agricultural areas}
\usage{
aspwbInput(crop_factor, control, soil)

aspwb_day(
  x,
  date,
  meteovec,
  latitude,
  elevation,
  slope = NA_real_,
  aspect = NA_real_,
  runon = 0,
  lateralFlows = NULL,
  waterTableDepth = NA_real_,
  modifyInput = TRUE
)

aspwb(
  x,
  meteo,
  latitude,
  elevation,
  slope = NA_real_,
  aspect = NA_real_,
  waterTableDepth = NA_real_
)
}
\arguments{
\item{crop_factor}{Agriculture crop factor.}

\item{control}{A list with default control parameters (see \code{\link{defaultControl}}).}

\item{soil}{An object of class \code{\link{data.frame}} or \code{\link{soil}}.}

\item{x}{An object of class \code{\link{aspwbInput}}.}

\item{date}{Date as string "yyyy-mm-dd".}

\item{meteovec}{A named numerical vector with weather data. See variable names in parameter \code{meteo} of \code{\link{spwb}}.}

\item{latitude}{Latitude (in degrees).}

\item{elevation, slope, aspect}{Elevation above sea level (in m), slope (in degrees) and aspect (in degrees from North).}

\item{runon}{Surface water amount running on the target area from upslope (in mm).}

\item{lateralFlows}{Lateral source/sink terms for each soil layer (interflow/to from adjacent locations) as mm/day.}

\item{waterTableDepth}{Water table depth (in mm). When not missing, capillarity rise will be allowed if lower than total soil depth.}

\item{modifyInput}{Boolean flag to indicate that the input \code{x} object is allowed to be modified during the simulation.}

\item{meteo}{A data frame with daily meteorological data series (see \code{\link{spwb}}).}
}
\description{
Function \code{aspwb_day} performs water balance for a single day in an agriculture location.
Function \code{aspwb} performs water balance for multiple days in an agriculture location.
}
\examples{

control <- defaultControl()
examplesoil <- defaultSoilParams(4)

x <- aspwbInput(0.75, control, examplesoil)

# Day to be simulated
d <- 100
meteovec <- unlist(examplemeteo[d,-1])
date <- as.character(examplemeteo$dates[d])

#Call simulation function for a single days
sd <- aspwb_day(x, date, meteovec,  
               latitude = 41.82592, elevation = 100) 

#Call simulation function for multiple days
S <- aspwb(x, examplemeteo, latitude = 41.82592, elevation = 100)

}
\seealso{
\code{\link{spwbInput}}, \code{\link{spwb}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
