% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_api.R
\name{mx_api_content}
\alias{mx_api_content}
\title{Access medRxiv/bioRxiv data via the Cold Spring Harbour Laboratory API}
\usage{
mx_api_content(
  from_date = "2013-01-01",
  to_date = as.character(Sys.Date()),
  clean = TRUE,
  server = "medrxiv",
  include_info = FALSE
)
}
\arguments{
\item{from_date}{Earliest date of interest. Defaults to 1st June 2019
(earliest medRxiv record was posted on 25th June 2019).}

\item{to_date}{Latest date of interest. Defaults to current date.}

\item{clean}{Logical, defaulting to TRUE, indicating whether to clean the
data returned by the API. If TRUE, variables containing absolute paths to
the preprints web-page ("link_page") and PDF ("link_pdf") are generated
from the "server", "DOI", and "version" variables returned by the API. The
"title", "abstract" and "authors" variables are converted to title case.
Finally, the "type" and "server" variables are dropped.}

\item{server}{Specify the server you wish to use: "medrxiv" (default) or
"biorxiv"}

\item{include_info}{Logical, indicating whether to include variables
containing information returned by the API (e.g. API status, cursor number,
total count of papers, etc). Default is FALSE.}
}
\value{
Dataframe with 1 record per row
}
\description{
Provides programmatic access to all preprints available through
  the Cold Spring Harbour Laboratory API, which serves both the medRxiv and
  bioRxiv preprint repositories.
}
\examples{
\donttest{
mx_data <- mx_api_content(from_date = "2020-01-01",
to_date = "2020-01-07")
}
}
\seealso{
Other data-source: 
\code{\link{mx_api_doi}()},
\code{\link{mx_snapshot}()}
}
\concept{data-source}
