% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_test.R
\name{confint.el_test}
\alias{confint.el_test}
\title{Confidence intervals for model parameters}
\usage{
\method{confint}{el_test}(object, parm, level = 0.95, control = list(), ...)
}
\arguments{
\item{object}{A fitted \code{"el_test"} object.}

\item{parm}{A specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{A confidence level required.}

\item{control}{A list of control parameters. See ‘Details’ in
\code{\link{lht}}.}

\item{...}{Additional argument(s) for methods.}
}
\value{
A matrix with columns giving lower and upper confidence limits for
 each parameter. In contrast to other methods that rely on studentization,
 the lower and upper limits obtained from empirical likelihood do not
 correspond to the (1 - level) / 2 and 1 - (1 - level) / 2 in \%,
 respectively.
}
\description{
Computes confidence intervals for one or more parameters in a fitted model.
Package \strong{melt} adds a method for objects inheriting from class
\code{"el_test"}.
}
\examples{
fit <- el_lm(formula = mpg ~ wt, data = mtcars)
confint(fit)
}
\references{
Kim, E., MacEachern, S., and Peruggia, M., (2021),
"Empirical Likelihood for the Analysis of Experimental Designs,"
\href{https://arxiv.org/abs/2112.09206}{arxiv:2112.09206}.
}
\seealso{
\link{lht}
}
