% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_mean.R
\name{el_mean}
\alias{el_mean}
\title{Empirical likelihood for the mean}
\usage{
el_mean(par, x, weights = NULL, control = el_control(), model = TRUE)
}
\arguments{
\item{par}{A numeric vector of parameter values to be tested.}

\item{x}{A numeric matrix, or an object that can be coerced to a numeric
matrix. Each row corresponds to an observation.}

\item{weights}{An optional numeric vector of weights to be used in the
fitting process. Defaults to \code{NULL}, corresponding to identical
weights. If non-\code{NULL}, weighted empirical likelihood is computed.}

\item{control}{A list of control parameters set by \code{\link{el_control}}.}

\item{model}{A logical. If \code{TRUE} the data matrix used for model fitting
is returned.}
}
\value{
An object of class \linkS4class{EL}.
}
\description{
Computes empirical likelihood for the mean.
}
\examples{
# scalar mean
par <- 0
x <- rnorm(100)
el_mean(par, x)

# vector mean
par <- c(0, 0)
x <- matrix(rnorm(100), ncol = 2)
el_mean(par, x)

# weighted data
par <- c(0, 0)
x <- matrix(rnorm(100), ncol = 2)
w <- rep(c(1, 2), each = 25)
el_mean(par, x, w)
}
\references{
Owen, Art. 1990. “Empirical Likelihood Ratio Confidence Regions.”
  The Annals of Statistics 18 (1): 90–120. \doi{10.1214/aos/1176347494}.
}
\seealso{
\link{el_control}, \link{el_eval}, \link{lht}
}
