\name{epitiming}
\alias{epitiming}
\alias{summary.epidemic}
\alias{plot.epidemic}
\alias{print.epidemic}
\title{
Influenza Epidemic Timing
}
\description{
Function \code{epitiming} is used to find the optimal timing of an influenza epidemic 
in a set of weekly influenza surveillance rates. It provides the start and the end of 
the epidemic, also it returns a list of pre-epidemic and post-epidemic rates that can 
be used to calculate influenza baselines and thresholds.\cr 
The method to calculate the optimal timing of an epidemic is described as part of the 
\emph{Moving Epidemics Method} (MEM), used to monitor influenza activity in a weekly 
surveillance system.
}
\usage{
epitiming(i.data, i.n.values = 5, i.method = 2, i.param = 2.8)
\method{print}{epidemic}(x, ...)
\method{summary}{epidemic}(object, ...)
\method{plot}{epidemic}(x, ...)
}
\arguments{
  \item{i.data}{
a numeric object  (or one that can be coerced to that class).
}
  \item{i.n.values}{
a number, which indicates how many pre-epidemic values are taken from the pre-epidemic 
period.
}
  \item{i.method}{
a number from 1 to 4, to select which optimization method to use.
}
  \item{i.param}{
an optional parameter used by the method.
}
  \item{x}{
An \code{epidemic} class item.
}
  \item{object}{
An \code{epidemic} class item.
}
  \item{\dots}{
Not used.
}
}
\details{
Input data is a vector of rates that represent a full influenza surveillance season. 
It can start and end at any week (tipically at week 40th), and rates can be expressed 
as per 100,000 inhabitants (or per consultations, if population is not available) or 
any other scale.\cr
The \code{i.n.values} parameter is used to get information from the pre-epidemic and 
post-epidemic period. The function will extract the highest pre/post values in order 
to use it later to calculate other influenza indicators, such as baseline activity or 
threshold for influenza epidemic.
Depending of the value \code{i.method}, the function will use a different method to 
calculate the optimum epidemic timing.
\tabular{rlll}{
\tab [1] \tab original method\cr
\tab [2] \tab fixed criterium method\cr
\tab [3] \tab slope method\cr
\tab [4] \tab second derivative method\cr
}
All methods are based upon the MAP curve, as described in the MEM Method.\cr
The \emph{original method} uses the process shown in the original paper, which describes 
the MEM as it was created. The \emph{fixed criterium method} is an update of the MEM 
that uses the slope of the MAP curve fo find the optimum, which is the point where the 
slope is lower than a predefined value. The \emph{slope method} also calculates the 
slope of the MAP curve, but the optimum is the one that matches the global/mean slope. 
The \emph{second derivative method} calculates the second derivative and equals to zero 
to search an inflexion point in the original curve.\cr
Two of the four methods require an additional parameter \code{i.param}: for the 
\emph{fixed criterium method} is the predefined value to find the optimum, which 
typically is 2.5-3.0\%, and for the \emph{original method} it is needed the window 
parameter to smooth the map curve. A value of \code{-1} indicates it should use 
\code{\link{h.select}} to select the window parameter. See \code{\link{sm}} for more 
information about this topic.
}
\value{
\code{epitiming} returns an object of class \code{epidemic}. 
An object of class \code{epidemic} is a list containing at least the following components: 
  \item{i.data }{input data}
  \item{map.curve }{MAP curve}
  \item{optimum.map }{optimum}
  \item{pre.epi }{pre-epidemic highest rates}
  \item{post.epi }{post-epidemic highest rates} 
}
\references{
Vega T., Lozano J.E. (2004) Modelling influenza epidemic - can we detect the beginning 
and predict the intensity and duration? International Congress Series 1263 (2004) 
281-283.\cr
Vega T., Lozano J.E. (2012) Influenza surveillance in Europe: establishing epidemic 
thresholds by the Moving Epidemic Method. Influenza and Other Respiratory Viruses, 
DOI:10.1111/j.1750-2659.2012.00422.x.
}
\author{
Jose E. Lozano Alonso <lozalojo@jcyl.es>.
}
\examples{
library(mem)

## Castilla y Leon Influenza Rates data 
data(flucyl)
## Finds the timing of the first season: 2001/2002
tim<-epitiming(flucyl[1])
print(tim)
summary(tim)
plot(tim)
}
\keyword{ influenza }
