% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverselog_trans.R
\name{reverselog_trans}
\alias{reverselog_trans}
\title{Reverse log transform}
\usage{
reverselog_trans(base = 10)
}
\arguments{
\item{base}{Base of the logarithm}
}
\description{
Reverse log transformation. Useful when plotting and one axis is in pressure
levels.
}
\examples{
# Adiabatic temperature profile
gamma <- 0.286
t <- data.frame(p = c(1000, 950, 850, 700, 500, 300, 200, 100))
t$t <- 300*(t$p/1000)^gamma

library(ggplot2)
ggplot(t, aes(p, t)) +
   geom_line() +
   coord_flip() +
   scale_x_continuous(trans = "reverselog")

}
\seealso{
Other ggplot2 helpers: \code{\link{DivideTimeseries}},
  \code{\link{MakeBreaks}}, \code{\link{WrapCircular}},
  \code{\link{geom_arrow}}, \code{\link{geom_contour2}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{scale_divergent}},
  \code{\link{scale_longitude}}, \code{\link{stat_na}},
  \code{\link{stat_subset}}
}
\concept{ggplot2 helpers}
