% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacr.R
\name{metacr}
\alias{metacr}
\title{Meta-analysis of outcome data from Cochrane review}
\usage{
metacr(
  x,
  comp.no = 1,
  outcome.no = 1,
  method,
  sm,
  level = gs("level"),
  level.ma = gs("level.ma"),
  common,
  random,
  hakn = FALSE,
  method.tau = "DL",
  method.tau.ci = gs("method.tau.ci"),
  tau.common = FALSE,
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  swap.events,
  logscale,
  backtransf = gs("backtransf"),
  test.subgroup,
  prediction.subgroup = gs("prediction.subgroup"),
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title,
  complab,
  outclab,
  keepdata = gs("keepdata"),
  warn = FALSE,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{rm5} created by R function
\code{read.rm5}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{method}{A character string indicating which method is to be
used for pooling of studies. One of \code{"Inverse"},
\code{"MH"}, or \code{"Peto"}, can be abbreviated.}

\item{sm}{A character string indicating which summary measure
(\code{"RR"}, \code{"OR"}, \code{"RD"}, \code{"ASD"},
\code{"HR"}, \code{"MD"}, or \code{"SMD"}, or \code{"ROM"}) is to
be used for pooling of studies.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.ma}{The level used to calculate confidence intervals
for pooled estimates.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{hakn}{A logical indicating whether the method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"PM"},
\code{"REML"}, \code{"ML"}, \code{"HS"}, \code{"SJ"},
\code{"HE"}, or \code{"EB"}, can be abbreviated.}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau}. Either \code{"QP"}, \code{"BJ"}, or \code{"J"}, or
\code{""}, can be abbreviated.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{swap.events}{A logical indicating whether events and
non-events should be interchanged.}

\item{logscale}{A logical indicating whether effect estimates are
entered on log-scale.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE} (default), results for \code{sm="OR"} are
printed as odds ratios rather than log odds ratios and results
for \code{sm="ZCOR"} are printed as correlations rather than
Fisher's z transformed correlations, for example.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if \code{incr} is added to studies with zero cell
frequencies).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{"meta"} and \code{"metabin"},
\code{"metacont"}, or \code{"metagen"} depending on outcome type
utilised in Cochrane Intervention review for selected outcome.
}
\description{
Wrapper function to perform meta-analysis for a single outcome of a
Cochrane Intervention review.
}
\details{
Cochrane Intervention reviews are based on the comparison of two
interventions. Each Cochrane Intervention review can have a
variable number of comparisons. For each comparison, a variable
number of outcomes can be define. For each outcome, a seperate
meta-analysis is conducted. Review Manager 5 (RevMan 5) is the
current software used for preparing and maintaining Cochrane
Reviews
(\url{https://training.cochrane.org/online-learning/core-software-cochrane-reviews/revman}).

This wrapper function can be used to perform meta-analysis for a
single outcome of a Cochrane Intervention review. Internally, R
functions \code{\link{metabin}}, \code{\link{metacont}}, and
\code{\link{metagen}} are called - depending on the definition of
the outcome in RevMan 5.

Note, it is recommended to choose the RevMan 5 settings before
executing \code{metacr}, i.e., \code{settings.meta("revman5")}.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv"
# in sub-directory of package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
#
Fleiss1993_CR <- read.rm5(filename)

# Choose RevMan 5 settings and store old settings
#
oldset <- settings.meta("revman5", quietly = FALSE)

# Same result as R command example(Fleiss1993bin)
#
metacr(Fleiss1993_CR)

# Same result as R command example(Fleiss1993cont)
#
metacr(Fleiss1993_CR, 1, 2)
forest(metacr(Fleiss1993_CR, 1, 2))

# Change summary measure to RR
#
m1 <- metacr(Fleiss1993_CR)
update(m1, sm="RR")

# Use old settings
#
settings.meta(oldset)

}
\references{
\emph{Review Manager (RevMan)} [Computer program]. Version 5.4.
The Cochrane Collaboration, 2020
}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}, \code{\link{read.rm5}},
  \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
