% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{estimates.meta}
\alias{estimates.meta}
\alias{estimates}
\alias{print.estimates.meta}
\title{Extract results from meta-analysis object}
\usage{
\method{estimates}{meta}(
  x,
  sortvar,
  study.results = TRUE,
  common = x$common,
  random = x$random,
  prediction = x$prediction,
  overall = x$overall,
  subgroup,
  prediction.subgroup = x$prediction.subgroup,
  se = FALSE,
  ci = TRUE,
  statistic = FALSE,
  pval = FALSE,
  n = TRUE,
  backtransf = x$backtransf,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  writexl = !missing(path),
  path = "estimates.xlsx",
  overwrite = FALSE,
  ...
)

estimates(x, ...)

\method{print}{estimates.meta}(
  x,
  digits.tau = gs("digits.tau"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  big.mark = gs("big.mark"),
  details = TRUE,
  ...
)
}
\arguments{
\item{x}{A meta-analysis object of class \code{meta}.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{study.results}{A logical indicating whether study results
should be extracted.}

\item{common}{A logical indicating whether results of common effect
meta-analysis should be extracted.}

\item{random}{A logical indicating whether results of random
effects meta-analysis should be extracted.}

\item{prediction}{A logical indicating whether prediction interval
should be extracted.}

\item{overall}{A logical indicating whether overall summaries
should be extracted. This argument is useful in a meta-analysis
with subgroups if overall results should not be extracted.}

\item{subgroup}{A logical indicating whether subgroup results
should be extracted.}

\item{prediction.subgroup}{A single logical or logical vector
indicating whether / which prediction intervals should be
extracted for subgroups.}

\item{se}{A logical indicating whether standard errors should be
extracted.}

\item{ci}{A logical indicating whether confidence / prediction
interval should be extracted.}

\item{statistic}{A logical indicating whether to extract statistic
of test for overall effect.}

\item{pval}{A logical indicating whether to extract p-value of test
for overall effect.}

\item{n}{A logical indicating whether sample sizes should be
extracted (if available).}

\item{backtransf}{A logical indicating whether extracted results
should be back transformed.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors, see \code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-statistic for test of overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{writexl}{A logical indicating whether an Excel file should be
created (R package \bold{writexl} must be available).}

\item{path}{A character string specifying the filename of the Excel
file.}

\item{overwrite}{A logical indicating whether an existing Excel
file should be overwritten.}

\item{\dots}{Additional arguments passed on to \code{prmatrix}.}

\item{digits.tau}{Minimal number of significant digits for square
root of between-study variance, see \code{print.default}.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{big.mark}{A character used as thousands separator.}

\item{details}{A logical specifying whether details on statistical
methods should be printed.}
}
\value{
A data frame with additional class 'extract.meta' or an Excel file.
}
\description{
Extract study and meta-analysis results from meta-analysis object
which can be stored in an Excel file.
}
\details{
Extract study and meta-analysis results from meta-analysis object.
By default, a data frame with the results is
generated. Alternatively, an Excel file is created if argument
\code{writexl = TRUE}.

The following information is extracted.

\tabular{ll}{
\bold{Variable} \tab \bold{Content} \cr
studlab \tab Study label / descriptor of meta-analysis result \cr
estimate \tab (Back transformed) estimate for individual studies /
  meta-analysis \cr
se \tab Standard error \cr
lower \tab Lower (back transformed) confidence / prediction
  interval limit \cr
upper \tab Upper (back transformed) confidence / prediction
  interval limit \cr
k \tab Number of studies \cr
df \tab Degrees of freedom for confidence / prediction intervals \cr
statistic \tab Statistic for test of effect \cr
pval \tab P-value for test of effect \cr
n \tab Total sample size \cr
n.e \tab Sample size in first (experimental) group \cr
n.c \tab Sample size in second (control) group
}

Some variables are only extracted if the corresponding logical
argument \code{se}, \code{ci}, \code{statistic} or \code{n} is
\code{TRUE}. Furthermore, (group) sample sizes are only extracted
if available in the meta-analysis object.

The variables \code{estimate}, \code{lower} and \code{upper}
contain the back transformed effects and confidence interval
limits, e.g., odds ratio (argument \code{sm = "OR"} in
\code{\link{metabin}} or \code{\link{metagen}}) or correlation
(\code{sm = "ZCOR"} in \code{\link{metacor}} or
\code{\link{metagen}}), if argument \code{backtransf} is
\code{TRUE}. Otherwise, these variables contain the transformed
values, e.g., log odds ratio (\code{sm = "OR"}) or Fisher's Z
transformed correlations (\code{sm = "ZCOR"}). See
\code{\link{meta-sm}} for available summary measures and
\code{\link{meta-transf}} for the corresponding transformations and
back transformations.
}
\examples{

m1 <- metacor(c(0.85, 0.7, 0.95), c(20, 40, 10))
summary(m1)
estimates(m1)
estimates(m1, backtransf = FALSE)
estimates(update(m1, common = FALSE, random = FALSE))
estimates(update(m1, prediction = TRUE))
estimates(update(m1, prediction = TRUE,
  level.ma = 0.99, level.predict = 0.9))

\dontrun{
# Create Excel file with extracted results
# (R package 'writexl' must be available)
if (requireNamespace("writexl", quietly = TRUE)) {
 fname1 <- tempfile(fileext = ".xlsx")
 estimates(m1, path = fname1)
 # An existing Excel file is not overwritten but a warning is printed
 estimates(m1, path = fname1)
 # Overwrite an existing Excel file
 estimates(m1, path = fname1, overwrite = TRUE)
 # Suppress message on file creation and overwrite existing file
 suppressMessages(estimates(m1, path = fname1, overwrite = TRUE))
}

# Save the extracted results in a text file
fname2 <- tempfile(fileext = ".csv")
fname2
write.csv(estimates(m1), file = fname2, row.names = FALSE)
}

}
\seealso{
\code{\link{meta-transf}}, \code{\link{meta-sm}},
  \code{\link{as.data.frame.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
