% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{bma}
\alias{bma}
\title{Bayesian Model Averaging}
\usage{
bma(meta, prior = 1, parameter = "d", summarize = "integrate")
}
\arguments{
\item{meta}{list of meta-analysis models (fitted via \code{\link{meta_random}} or \code{\link{meta_fixed}})}

\item{prior}{prior probabilities over models (possibly unnormalized). For instance, if the first model is as likely as models 2, 3 and 4 together: \code{prior = c(3,1,1,1)}. The default is a discrete uniform distribution over models.}

\item{parameter}{eiher the mean effect \code{"d"} or the heterogeneity across studies \code{"tau"}}

\item{summarize}{whether and to compute parameter summaries (mean, median, SD, 95\% quantile interval, HPD interval). If \code{summarize = "integrate"}, numerical integration is used  (which is precise but can require some seconds of computing time), \code{summarize = "jags"} summarizes the JAGS samples, and \code{summarize = "none"} suppresses parameter summaries.}
}
\description{
Model averaging of meta-analysis models according to their posterior model probability.
}
\examples{
data(towels)
fix1 <- meta_fixed(towels$logOR, towels$SE, towels$study,
                   d = "halfnorm", d.par = c(mean=0, sd=.2))
fix2 <- meta_fixed(towels$logOR, towels$SE, towels$study,
                   d = "beta", d.par = c(alpha=1, beta=1))
fix3 <- meta_fixed(towels$logOR, towels$SE, towels$study,
                   d = "triangular",
                   d.par = c(min=0, peak=.3, max=1))

averaged <- bma(list(Halfnormal = fix1, Uniform = fix2,
                     Triangular = fix3))
averaged
plot_posterior(averaged)
plot_forest(averaged, mar = c(4.5,20,4,.3))
}
