% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_compare_df.R
\name{compare_df}
\alias{compare_df}
\title{Flag the differences between two dataframes.}
\usage{
compare_df(
  df_extractor_1,
  df_extractor_2,
  ordering_columns = NULL,
  tolerance = 0,
  tolerance_type = "ratio",
  output = "html",
  file_name = "comparison.xlsx"
)
}
\arguments{
\item{df_extractor_1}{a first dataset. Differences with the second dataset will be flagged in green.}

\item{df_extractor_2}{a second dataset. Differences with the first dataset will be flagged in red.}

\item{ordering_columns}{column names that should be used to re-order the two datasets before running the comparisons}

\item{tolerance}{the cut-off value used to flag differences between two numeric values}

\item{tolerance_type}{must be either 'difference' or 'ratio'}

\item{output}{type of object returned by the function (see 'Value' section). Must be either 'wide', 'long', 'html', 'html2' or 'xlsx'.}

\item{file_name}{the name of the generated file (only used when \code{output="xlsx"})}
}
\value{
This function returns a dataframe composed of the rows that include a
difference (all identical rows are removed).
Several outputs can be requested :
\enumerate{
\item setting \code{output="xlsx"} returns an excel file. A message indicates the location of the generated file on your computer.
\item setting \code{output="html"} returns an html file
\item setting \code{output="html2"} returns an html file (only useful when the "html" command did not make the html pane appear in R studio).
\item setting \code{output="wide"} a wide dataframe
\item setting \code{output="long"} a long dataframe
}
}
\description{
Flag the differences between two dataframes.
}
\details{
This function aims to facilitate the comparison of two datasets created by blind data extractors during a systematic review.
It is a wrapper of several functions from the 'compareDF' package.
}
\examples{
df.compare1 = df.compare1[order(df.compare1$author), ]
df.compare2 = df.compare2[order(df.compare2$year), ]
names(df.compare1)[2] <- "generate_warning"

compare_df(
  df_extractor_1 = df.compare1,
  df_extractor_2 = df.compare2,
  ordering_columns = c("study_id")
)
}
\references{
Alex Joseph (2022). compareDF: Do a Git Style Diff of the Rows Between Two Dataframes with Similar Structure. R package version 2.3.3. https://CRAN.R-project.org/package=compareDF
}
