% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEmatcor.R
\name{metaGE.cor}
\alias{metaGE.cor}
\title{Infer inter-environment correlation matrix}
\usage{
metaGE.cor(Data, Threshold = 0.6, NA.omit = TRUE, Cores = NULL)
}
\arguments{
\item{Data}{A dataset containing the effects and pvalues of each marker (in rows) in each environment (in columns) as obtained by \code{\link[=metaGE.collect]{metaGE.collect()}}.}

\item{Threshold}{Threshold on posteriors (to be H1) to filter markers before computing correlation (\code{0.6} by default).}

\item{NA.omit}{A boolean: should the NA be removed for the inter-environment correlation matrix computation (\code{TRUE} by default).}

\item{Cores}{The number of cores to used, optional. By default, \code{availableCores()-1} cores is used.}
}
\value{
The inter-environment correlation matrix
}
\description{
This function infer the inter-environment correlation matrix from the z-scores after filtering markers with high probability of being under H1.
}
\examples{
require(corrplot)
data("metaData")
Threshold <- 0.8
matCorr <- metaGE.cor(metaData, Threshold = Threshold)
#corrplot(matCorr,order = "hclust")
}
