% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEplot.R
\name{metaGE.heatmap}
\alias{metaGE.heatmap}
\title{Draw the heatmap to see markers effects across environments.}
\usage{
metaGE.heatmap(
  Data,
  Prefix = "Z.",
  EnvGroups = NULL,
  QTLsVarName = NULL,
  RowOrder = TRUE,
  ColOrder = TRUE,
  ShowDendrogram = FALSE,
  Colors = c("red", "black", "green"),
  Main = ""
)
}
\arguments{
\item{Data}{A dataset containing the zscores, the effects or the pvalues of each marker (in rows) in each environment (in columns), as obtained from \code{\link[=metaGE.fit]{metaGE.fit()}}.}

\item{Prefix}{The prefix of the score to display in the heatmap: "\code{Z.}" for the zscores, "\code{EFFECT.}" for the effects and "\code{PVAL.}" for the pvalues.("\code{Z.}" by default)}

\item{EnvGroups}{A dataset containing the names of the environments (in the first column) and the groups to which the environments belong (in the second column). (optional)}

\item{QTLsVarName}{The name of the column indicating to which QTL the marker belongs.  (optional)}

\item{RowOrder}{A boolean specifying whether to reorder the markers or not. (\code{TRUE} by default)}

\item{ColOrder}{A boolean specifying whether to reorder the environments or not. (\code{TRUE} by default)}

\item{ShowDendrogram}{A boolean specifying whether to show the clustering of the rows and/or the columns. (\code{FALSE} by default)}

\item{Colors}{A vector of three colors corresponding to the color scale of the Heatmap.(optional)}

\item{Main}{The main to display.(optional)}
}
\value{
The heatmap
}
\description{
The function metaGE.heatmap displays the heatmap of the zscores, the estimated marker effects or the pvalues of each markers (in rows) in each environments (in columns).
}
\examples{
require(dplyr)
# Import the data
data("metaData")

# Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

# Fit the Fixed Effect model
FeDF <- metaGE.fit(metaData, matCorr, Method = "Fe")

# Control the FDR (here Benjamini-Hochberg)
Alpha <- 0.05
Signif <-  FeDF$PVALUE \%>\% p.adjust(method = "BH") \%>\% `<`(Alpha) \%>\% which

# Draw the z-scores heatmap of the significant markers
heatmap <- metaGE.heatmap(Data = FeDF[Signif,],
                         Prefix = "Z.")
}
