% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_roc.r
\name{predict_roc.metaSDTreg}
\alias{predict_roc.metaSDTreg}
\title{Predicted ROC curve}
\usage{
\method{predict_roc}{metaSDTreg}(object, type = c("1", "n", "s"), s0 = 0, s1 = 1, ...)
}
\arguments{
\item{object}{An object of class \code{metaSDTreg}.}

\item{type}{The type of ROC curve to predict. A character string, where '1' requests the type 1 ROC curve (the default), 'n' requests the type 2 noise-specific and 's' the type 2 signal-specific ROC curve.}

\item{s0}{Numeric, the value of 'signal' to regard as 'noise'. Defaults to 0.}

\item{s1}{Numeric, the value of 'signal' to regard as 'signal'. Defaults to 1.}

\item{...}{For future methods}
}
\value{
A function of class 'predict_roc' containing the appropriate ROC curve. This is a function of x which returns c(FA,HR), where FA is the false alarm rate and HR is the hit rate.
}
\description{
Predict ROC curves from metaSDTreg object.
}
\details{
The 'metaSDTreg' object given to the function must have named coefficients with names as they would be if \code{metaSDTreg} is run without user-supplied starting values.

A ROC curve is a 2-D curve parametrised by some x given by c(FA(x), HR(x)) where FA is the false alarm rate and HR is the hit rate. For example, for type 1 ROC,
\deqn{FA(x) = 1 - pnorm(x - s0*d),} 
\deqn{HR(x) = 1 - pnorm(x - s1*d),}
where \eqn{d} is the signal sensitivity.

Note that the predicted ROC curve is for a reference individual in the regression, i.e. additional covariates are not entered into the ROC so that reparametrisation of the 'metaSDTreg' model is needed to change predictions.
}
\examples{
## Declare simulated data as metaSDTdata
metadata <- metaSDTdata(simMetaData, type1='resp', type2='conf', signal='S')

## Fit model to subset of data
fit <- metaSDTreg(A ~ signal,
            data=metadata,
            subset = m <= 20)

## Model-predicted signal-specific ROC curve
signalROC <- predict_roc(fit, type = 's')

}
\references{
Maniscalco, B., & Lau, H. (2014).
Signal Detection Theory Analysis of Type 1 and Type 2 Data: Meta-d , Response-Specific Meta-d , and the Unequal Variance SDT Model.
In S. M. Fleming, & C. D. Frith (Eds.), The {Cognitive} {Neuroscience} of {Metacognition}
(pp. 25 66). : Springer Berlin Heidelberg.
}
