\name{metaSEM-package}
\alias{metaSEM-package}
\alias{metaSEM}
\docType{package}
\title{Meta-Analysis using Structural Equation Modeling
}
\description{A collection of functions for conducting meta-analysis using a
             structural equation modeling (SEM) approach via the 'OpenMx' and
             'lavaan' packages. It also implements various procedures to
			 perform meta-analytic structural equation modeling on the
             correlation and covariance matrices.
}
\details{
\tabular{ll}{
Package: \tab metaSEM\cr
Type: \tab Package\cr
Version: \tab 1.2.0\cr
Date: \tab 2018-10-18\cr
License: \tab GPL (>=2)\cr
LazyLoad: \tab yes\cr
}
}
\author{Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>

Maintainer: Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>
}
\references{
Cheung, M. W.-L. (2008). A model for integrating fixed-, random-, and mixed-effects meta-analyses into structural equation modeling. \emph{Psychological Methods}, \bold{13}, 182-202. 

Cheung, M. W.-L. (2009). Constructing approximate confidence intervals for parameters with structural equation models. \emph{Structural Equation Modeling}, \bold{16}, 267-294.

Cheung, M. W.-L. (2010). Fixed-effects meta-analyses as multiple-group structural equation models. \emph{Structural Equation Modeling}, \bold{17}, 481-509.

Cheung, M. W.-L. (2013). Implementing restricted maximum likelihood estimation in structural equation models. \emph{Structural Equation Modeling}, \bold{20}, 157-167. 

Cheung, M. W.-L. (2013). Multivariate meta-analysis as structural equation models. \emph{Structural Equation Modeling}, \bold{20}, 429-454.

Cheung, M. W.-L. (2014). Modeling dependent effect sizes with three-level meta-analyses: A structural equation modeling approach. \emph{Psychological Methods}, \bold{19}, 211-229.

Cheung, M. W.-L. (2014). Fixed- and random-effects meta-analytic structural equation modeling: Examples and analyses in R. \emph{Behavior Research Methods}, \bold{46}, 29-40. 

Cheung, M. W.-L. (2015). metaSEM: An R package for meta-analysis using structural equation modeling. \emph{Frontiers in Psychology}, \bold{5}, 1521.

Cheung, M. W.-L. (2015). \emph{Meta-Analysis: A Structural Equation Modeling Approach}. Chichester, West Sussex: John Wiley & Sons, Inc.

Cheung, M. W.-L. (2018). Issues in solving the problem of effect size
heterogeneity in meta-analytic structural equation modeling: A
commentary and simulation study on Yu, Downes, Carter, and O'Boyle (2016). \emph{Journal of Applied Psychology}, \bold{103}, 787-803.

Cheung, M. W.-L. (2018). Computing multivariate effect sizes and their sampling covariance matrices with structural equation modeling: Theory, examples, and computer simulations. \emph{Frontiers in Psychology}, \bold{9}(1387). https://doi.org/10.3389/fpsyg.2018.01387

Cheung, M. W.-L. (2018). Some reflections on combining meta-analysis and structural equation modeling. \emph{Research Synthesis Methods}, \bold{0}(0).

Cheung, M. W.-L., & Chan, W. (2004). Testing dependent correlation coefficients via structural equation modeling. \emph{Organizational Research Methods}, \bold{7}, 206-223.

Cheung, M. W.-L., & Chan, W. (2005). Meta-analytic structural equation modeling: A two-stage approach. \emph{Psychological Methods}, \bold{10}, 40-64.

Cheung, M. W.-L., & Chan, W. (2009). A two-stage approach to synthesizing covariance matrices in meta-analytic structural equation modeling. \emph{Structural Equation Modeling}, \bold{16}, 28-53.

Cheung, M. W.-L., & Cheung, S.-F. (2016). Random-effects models for meta-analytic structural equation modeling: Review, issues, and illustrations. \emph{Research Synthesis Methods}, \bold{7}, 140-155.

Jak, S, & Cheung, M. W.-L. (2018). Testing moderator hypotheses in meta-analytic structural equation modeling using subgroup analysis. \emph{Behavior Research Methods}, \bold{50}, 1359-1373.
}
\keyword{ package }


