% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/70_depr.R
\name{plot_triplets}
\alias{plot_triplets}
\title{Plot peak triplets for variable range}
\usage{
plot_triplets(
  deconv_result,
  x_range = c(),
  y_range = c(),
  out_dir = ".",
  ask = TRUE
)
}
\arguments{
\item{deconv_result}{Saved result of the MetaboDecon1D() function}

\item{x_range}{Row vector with two entries consisting of the ppm start and the ppm end value
to scale the range of the x-axis (optional)}

\item{y_range}{Row vector with two entries consisting of the ppm start and the ppm end value
to scale the range of the y-axis (optional)}

\item{out_dir}{Directory to save the png files (optional)}

\item{ask}{Logical value to ask the user if the png files should be saved in the
specified directory (optional)}
}
\value{
No return value, called for side effect of plotting.
}
\description{
Plots the peak triplets for each peak detected by \code{\link[=MetaboDecon1D]{MetaboDecon1D()}} and stores the plots as png at \code{outdir}.

Superseded by \code{\link[=plot_spectrum]{plot_spectrum()}} since metabodecon v1.2.0. Will be replaced with v2.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
sim <- metabodecon_file("bruker/sim_subset")
sim_decon <- generate_lorentz_curves_sim(sim)
png_dir <- tmpdir("sim_decon/pngs", create = TRUE)
plot_triplets(sim_decon, out_dir = png_dir, ask = FALSE)
dir(png_dir, full.names = TRUE)
}
\seealso{
\code{\link[=MetaboDecon1D]{MetaboDecon1D()}}, \code{\link[=calculate_lorentz_curves]{calculate_lorentz_curves()}}, \code{\link[=plot_lorentz_curves_save_as_png]{plot_lorentz_curves_save_as_png()}},
\code{\link[=plot_spectrum_superposition_save_as_png]{plot_spectrum_superposition_save_as_png()}}
}
\author{
Martina Haeckl, 2021: Initial version.
Tobias Schmidt, 2024: Minor updates to pass CRAN checks.
}
